/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.net.covers1624.quack.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ByteArrayReadableChannel
implements ReadableByteChannel {
    private final byte[] buf;
    private final int end;
    private int pos;
    private boolean open = true;

    public ByteArrayReadableChannel(byte[] buf) {
        this.buf = buf;
        this.end = buf.length;
        this.pos = 0;
    }

    public ByteArrayReadableChannel(byte[] buf, int off, int end) {
        this.buf = buf;
        this.end = end;
        this.pos = off;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.pos == this.end) {
            return -1;
        }
        int toRead = Math.min(this.end - this.pos, dst.remaining());
        dst.put(this.buf, this.pos, toRead);
        this.pos += toRead;
        return toRead;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
    }
}

