/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.net.covers1624.quack.io;

import io.codechicken.repack.net.covers1624.quack.net.download.DownloadListener;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProgressInputStream
extends FilterInputStream {
    private final DownloadListener listener;
    private long totalLen;

    public ProgressInputStream(InputStream in, DownloadListener listener) {
        this(in, listener, 0L);
    }

    public ProgressInputStream(InputStream in, DownloadListener listener, long totalLen) {
        super(in);
        this.listener = listener;
        this.totalLen = totalLen;
    }

    @Override
    public int read() throws IOException {
        int r = super.read();
        if (r == -1) {
            this.listener.finish(this.totalLen);
        } else {
            ++this.totalLen;
            this.listener.update(this.totalLen);
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        this.totalLen += n;
        this.listener.update(this.totalLen);
        return super.skip(n);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = super.read(b, off, len);
        if (r == -1) {
            this.listener.finish(this.totalLen);
        } else {
            this.totalLen += (long)r;
            this.listener.update(this.totalLen);
        }
        return r;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

