/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.net.covers1624.quack.net.httpapi.java11;

import io.codechicken.repack.net.covers1624.quack.net.httpapi.AbstractEngineRequest;
import io.codechicken.repack.net.covers1624.quack.net.httpapi.EngineRequest;
import io.codechicken.repack.net.covers1624.quack.net.httpapi.EngineResponse;
import io.codechicken.repack.net.covers1624.quack.net.httpapi.MultipartBody;
import io.codechicken.repack.net.covers1624.quack.net.httpapi.WebBody;
import io.codechicken.repack.net.covers1624.quack.net.httpapi.java11.Java11EngineResponse;
import io.codechicken.repack.net.covers1624.quack.net.httpapi.java11.Java11HttpEngine;
import io.codechicken.repack.net.covers1624.quack.util.SneakyUtils;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.concurrent.Flow;
import org.jetbrains.annotations.Nullable;

public class Java11EngineRequest
extends AbstractEngineRequest {
    private final Java11HttpEngine engine;
    @Nullable
    private String method;
    @Nullable
    private WebBody body;

    Java11EngineRequest(Java11HttpEngine engine) {
        this.engine = engine;
    }

    @Override
    public EngineRequest method(String method, @Nullable WebBody body) {
        this.method = method;
        this.body = body;
        return this;
    }

    @Override
    protected void assertState() {
        super.assertState();
        if (this.method == null) {
            throw new IllegalStateException("method(String, Body) must be called first");
        }
    }

    @Override
    public EngineResponse execute() throws IOException {
        this.assertState();
        if (this.url == null) {
            throw new IllegalStateException("Url not set.");
        }
        if (this.body != null && this.headers.get("Content-Type") == null) {
            this.headers.add("Content-Type", this.body.contentType());
        }
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        builder.uri(URI.create(this.url));
        builder.method(this.method, this.body != null ? Java11EngineRequest.toPublisher(this.body) : HttpRequest.BodyPublishers.noBody());
        if (!this.headers.isEmpty()) {
            builder.headers(this.headers.toArray());
        }
        try {
            return new Java11EngineResponse(this, this.engine.getClient().send(builder.build(), HttpResponse.BodyHandlers.ofInputStream()));
        }
        catch (InterruptedException ex) {
            throw new IOException("Request failed. Interrupted.", ex);
        }
    }

    private static HttpRequest.BodyPublisher toPublisher(final WebBody body) {
        if (body instanceof MultipartBody) {
            throw new UnsupportedOperationException("Multipart requests are not supported by this engine yet.");
        }
        return new HttpRequest.BodyPublisher(){

            @Override
            public long contentLength() {
                return body.length();
            }

            @Override
            public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
                HttpRequest.BodyPublishers.ofInputStream(SneakyUtils.sneak(body::open)).subscribe(subscriber);
            }
        };
    }
}

