/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.tile;

import codechicken.lib.data.MCDataByteBuf;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.inventory.InventorySimple;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ArrayUtils;
import codechicken.lib.util.ItemUtils;
import codechicken.lib.vec.Vector3;
import codechicken.translocators.init.TranslocatorsModContent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;

public class TileCraftingGrid
extends BlockEntity {
    public ItemStack[] items = (ItemStack[])ArrayUtils.fill((Object[])new ItemStack[9], (Object)ItemStack.EMPTY);
    public ItemStack result = ItemStack.EMPTY;
    public int rotation = 0;
    public int timeout = 400;

    public TileCraftingGrid(BlockPos pos, BlockState state) {
        super((BlockEntityType)TranslocatorsModContent.tileCraftingGridType.get(), pos, state);
    }

    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("items", (Tag)InventoryUtils.writeItemStacksToTag((ItemStack[])this.items));
        tag.putInt("timeout", this.timeout);
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        InventoryUtils.readItemStacksFromTag((ItemStack[])this.items, (ListTag)tag.getList("items", 10));
        this.timeout = tag.getInt("timeout");
    }

    public void tickServer() {
        --this.timeout;
        if (this.timeout == 0) {
            this.dropItems();
            this.level.removeBlock(this.getBlockPos(), false);
        }
    }

    public void dropItems() {
        Vector3 drop = Vector3.fromTileCenter((BlockEntity)this);
        for (ItemStack item : this.items) {
            if (item.isEmpty()) continue;
            ItemUtils.dropItem((ItemStack)item, (Level)this.level, (Vector3)drop);
        }
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, e -> {
            MCDataByteBuf packet = new MCDataByteBuf();
            this.writeToPacket((MCDataOutput)packet);
            CompoundTag tag = new CompoundTag();
            packet.writeToNBT(tag, "data");
            return tag;
        });
    }

    public CompoundTag getUpdateTag() {
        MCDataByteBuf packet = new MCDataByteBuf();
        this.writeToPacket((MCDataOutput)packet);
        return packet.writeToNBT(super.getUpdateTag(), "data");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readFromPacket((MCDataInput)MCDataByteBuf.readFromNBT((CompoundTag)pkt.getTag(), (String)"data"));
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readFromPacket((MCDataInput)MCDataByteBuf.readFromNBT((CompoundTag)tag, (String)"data"));
    }

    public void writeToPacket(MCDataOutput packet) {
        packet.writeByte(this.rotation);
        for (ItemStack item : this.items) {
            packet.writeItemStack(item);
        }
    }

    public void readFromPacket(MCDataInput packet) {
        this.rotation = packet.readUByte();
        for (int i = 0; i < 9; ++i) {
            this.items[i] = packet.readItemStack();
        }
        this.updateResult();
    }

    public void activate(int subHit, Player player) {
        ItemStack held = player.getInventory().getSelected();
        if (held.isEmpty()) {
            if (!this.items[subHit].isEmpty()) {
                this.giveOrDropItem(this.items[subHit], player);
            }
            this.items[subHit] = ItemStack.EMPTY;
        } else if (!InventoryUtils.areStacksIdentical((ItemStack)held, (ItemStack)this.items[subHit])) {
            ItemStack old = this.items[subHit];
            this.items[subHit] = ItemUtils.copyStack((ItemStack)held, (int)1);
            player.getInventory().removeItem(player.getInventory().selected, 1);
            if (!old.isEmpty()) {
                this.giveOrDropItem(old, player);
            }
        }
        this.timeout = 2400;
        BlockState state = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), state, state, 3);
        this.setChanged();
    }

    private void updateResult() {
        CraftingContainer craftMatrix = this.getCraftMatrix();
        for (int i = 0; i < 4; ++i) {
            Optional mresult = this.level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)craftMatrix, this.level);
            if (mresult.isPresent()) {
                this.result = ((CraftingRecipe)((RecipeHolder)mresult.get()).value()).assemble((Container)craftMatrix, this.level.registryAccess());
                return;
            }
            this.rotateItems(craftMatrix);
        }
        this.result = ItemStack.EMPTY;
    }

    private void giveOrDropItem(ItemStack stack, Player player) {
        if (player.getInventory().add(stack)) {
            player.inventoryMenu.broadcastChanges();
        } else {
            ItemUtils.dropItem((ItemStack)stack, (Level)this.level, (Vector3)Vector3.fromTileCenter((BlockEntity)this));
        }
    }

    public void craft(ServerPlayer player) {
        CraftingContainer craftMatrix = this.getCraftMatrix();
        for (int i = 0; i < 4; ++i) {
            RecipeHolder holder;
            CraftingRecipe recipe;
            Optional mresult = this.level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)craftMatrix, this.level);
            if (mresult.isPresent() && ((recipe = (CraftingRecipe)(holder = (RecipeHolder)mresult.get()).value()).isSpecial() || !this.level.getGameRules().getBoolean(GameRules.RULE_LIMITED_CRAFTING) || player.getRecipeBook().contains(holder))) {
                this.doCraft((RecipeHolder<CraftingRecipe>)holder, recipe.assemble((Container)craftMatrix, this.level.registryAccess()), craftMatrix, (Player)player);
                break;
            }
            this.rotateItems(craftMatrix);
        }
        player.swing(InteractionHand.MAIN_HAND);
        this.dropItems();
        this.level.removeBlock(this.getBlockPos(), false);
    }

    private CraftingContainer getCraftMatrix() {
        GridCraftingInventory craftMatrix = new GridCraftingInventory();
        for (int i = 0; i < 9; ++i) {
            craftMatrix.setItem(i, this.items[i]);
        }
        return craftMatrix;
    }

    private void doCraft(RecipeHolder<CraftingRecipe> holder, ItemStack mresult, CraftingContainer craftMatrix, Player player) {
        int i;
        this.giveOrDropItem(mresult, player);
        mresult.onCraftedBy(this.level, player, mresult.getCount());
        EventHooks.firePlayerCraftingEvent((Player)player, (ItemStack)mresult, (Container)craftMatrix);
        player.triggerRecipeCrafted(holder, craftMatrix.getItems());
        CraftingRecipe recipe = (CraftingRecipe)holder.value();
        if (!recipe.isSpecial()) {
            player.awardRecipes(Collections.singleton(holder));
        }
        CommonHooks.setCraftingPlayer((Player)player);
        NonNullList remaining = recipe.getRemainingItems((Container)craftMatrix);
        CommonHooks.setCraftingPlayer(null);
        for (i = 0; i < remaining.size(); ++i) {
            ItemStack invStack = craftMatrix.getItem(i);
            ItemStack remStack = (ItemStack)remaining.get(i);
            if (!invStack.isEmpty()) {
                craftMatrix.removeItem(i, 1);
                invStack = craftMatrix.getItem(i);
            }
            if (remStack.isEmpty()) continue;
            if (invStack.isEmpty()) {
                craftMatrix.setItem(i, remStack);
                continue;
            }
            if (ItemStack.isSameItemSameTags((ItemStack)invStack, (ItemStack)remStack)) {
                remStack.grow(invStack.getCount());
                craftMatrix.setItem(i, remStack);
                continue;
            }
            this.giveOrDropItem(remStack, player);
        }
        for (i = 0; i < 9; ++i) {
            this.items[i] = craftMatrix.getItem(i);
        }
    }

    private void rotateItems(CraftingContainer inv) {
        int i;
        int[] slots = new int[]{0, 1, 2, 5, 8, 7, 6, 3};
        ItemStack[] arrangement = new ItemStack[9];
        arrangement[4] = inv.getItem(4);
        for (i = 0; i < 8; ++i) {
            arrangement[slots[(i + 2) % 8]] = inv.getItem(slots[i]);
        }
        for (i = 0; i < 9; ++i) {
            inv.setItem(i, arrangement[i]);
        }
    }

    public void onPlaced(LivingEntity entity) {
        this.rotation = (int)((double)(entity.getYRot() * 4.0f / 360.0f) + 0.5) & 3;
    }

    private static class GridCraftingInventory
    extends InventorySimple
    implements CraftingContainer {
        public GridCraftingInventory() {
            super(9);
        }

        public int getWidth() {
            return 3;
        }

        public int getHeight() {
            return 3;
        }

        public List<ItemStack> getItems() {
            return Arrays.asList(this.items);
        }

        public void fillStackedContents(StackedContents pContents) {
            for (ItemStack item : this.items) {
                pContents.accountSimpleStack(item);
            }
        }
    }
}

