/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.init;

import codechicken.lib.datagen.ItemModelProvider;
import codechicken.lib.datagen.recipe.RecipeProvider;
import codechicken.translocators.client.render.RenderTranslocatorItem;
import codechicken.translocators.init.TranslocatorsModContent;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class DataGenerators {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");

    public static void init(IEventBus modBus) {
        LOCK.lock();
        modBus.addListener(DataGenerators::gatherDataGenerators);
    }

    private static void gatherDataGenerators(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper files = event.getExistingFileHelper();
        gen.addProvider(event.includeClient(), (DataProvider)new ItemModels(output, files));
        gen.addProvider(event.includeClient(), (DataProvider)new BlockStates(output, files));
        BlockTags blockTags = (BlockTags)gen.addProvider(event.includeServer(), (DataProvider)new BlockTags(output, lookupProvider, files));
        gen.addProvider(event.includeServer(), (DataProvider)new ItemTags(output, lookupProvider, blockTags.contentsGetter(), files));
        gen.addProvider(event.includeServer(), (DataProvider)new Recipes(lookupProvider, output));
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "translocators", existingFileHelper);
        }

        protected void registerModels() {
            this.clazz((Supplier)TranslocatorsModContent.itemTranslocatorItem, RenderTranslocatorItem.Item.class);
            this.clazz((Supplier)TranslocatorsModContent.fluidTranslocatorItem, RenderTranslocatorItem.Fluid.class);
            this.generated((Supplier)TranslocatorsModContent.diamondNuggetItem);
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
            super(output, "translocators", exFileHelper);
        }

        protected void registerStatesAndModels() {
            ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent("dummy", "block")).texture("particle", "translocators:block/crafting_grid");
            this.simpleBlock((Block)TranslocatorsModContent.blockCraftingGrid.get(), (ModelFile)model);
        }
    }

    private static class BlockTags
    extends BlockTagsProvider {
        public BlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper files) {
            super(output, lookupProvider, "translocators", files);
        }

        protected void addTags(HolderLookup.Provider pProvider) {
        }
    }

    private static class ItemTags
    extends ItemTagsProvider {
        public ItemTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider, ExistingFileHelper files) {
            super(output, lookupProvider, blockTagProvider, "translocators", files);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(TranslocatorsModContent.diamondNuggetTag).add((Object)((Item)TranslocatorsModContent.diamondNuggetItem.get()));
            this.tag(Tags.Items.NUGGETS).add((Object)((Item)TranslocatorsModContent.diamondNuggetItem.get()));
            this.tag(TranslocatorsModContent.regulateItemsTag).addTags(new TagKey[]{TranslocatorsModContent.diamondNuggetTag});
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(CompletableFuture<HolderLookup.Provider> lookupProvider, PackOutput output) {
            super(lookupProvider, output, "translocators");
        }

        protected void registerRecipes() {
            this.shapelessRecipe((ItemLike)Items.DIAMOND, 1, ResourceLocation.fromNamespaceAndPath((String)"translocators", (String)"diamond_nugget_combine")).addIngredient((ItemLike)TranslocatorsModContent.diamondNuggetItem.get(), 9);
            this.shapelessRecipe((ItemLike)TranslocatorsModContent.diamondNuggetItem.get(), 9).addIngredient((ItemLike)Items.DIAMOND);
            this.shapedRecipe((ItemLike)TranslocatorsModContent.itemTranslocatorItem.get(), 2).patternLine("RER").patternLine("IPI").patternLine("RGR").key('R', Tags.Items.DUSTS_REDSTONE).key('E', Tags.Items.ENDER_PEARLS).key('I', Tags.Items.INGOTS_IRON).key('P', (ItemLike)Items.PISTON).key('G', Tags.Items.INGOTS_GOLD);
            this.shapedRecipe((ItemLike)TranslocatorsModContent.fluidTranslocatorItem.get(), 2).patternLine("RER").patternLine("IPI").patternLine("RLR").key('R', Tags.Items.DUSTS_REDSTONE).key('E', Tags.Items.ENDER_PEARLS).key('I', Tags.Items.INGOTS_IRON).key('P', (ItemLike)Items.PISTON).key('L', Tags.Items.GEMS_LAPIS);
        }
    }
}

