/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.part;

import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.render.CCModel;
import codechicken.lib.texture.AtlasRegistrar;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import mrtjp.projectred.illumination.MultipartLightProperties;
import mrtjp.projectred.illumination.MultipartLightType;
import mrtjp.projectred.illumination.part.MultipartLightFacePart;
import mrtjp.projectred.illumination.part.MultipartLightPart;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LanternLightProperties
extends MultipartLightProperties {
    private static final Cuboid6 BOUNDS = new Cuboid6(0.35, 0.25, 0.35, 0.65, 0.75, 0.65);
    private static final Cuboid6 GLOW_BOUNDS = BOUNDS.copy().expand(-0.015625);
    private static final VoxelShape SHAPE = VoxelShapeCache.getShape((Cuboid6)BOUNDS);
    @Nullable
    private TextureAtlasSprite icon;

    @Override
    public VoxelShape getShape(int side) {
        return SHAPE;
    }

    @Override
    public Cuboid6 getBounds(int side) {
        return BOUNDS;
    }

    @Override
    public ItemStack makeStack(int color, boolean inverted) {
        return MultipartLightType.LANTERN.makeStack(color, inverted);
    }

    @Override
    public MultipartLightPart partFactory(int color, boolean inverted) {
        return new MultipartLightFacePart(MultipartLightType.LANTERN.getPartType(color, inverted), this, color, inverted);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerIcons(AtlasRegistrar registrar) {
        registrar.registerSprite(new ResourceLocation("projectred_illumination", "block/lantern"), i -> {
            this.icon = i;
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getIcon(int color) {
        assert (this.icon != null);
        return this.icon;
    }

    @Override
    public Cuboid6 getGlowBounds(int side) {
        return GLOW_BOUNDS;
    }

    @Override
    public CCModel getBulbModel(int side) {
        return LanternLightModels.BULB_MODEL;
    }

    @Override
    public CCModel getChasisModel(int side) {
        return LanternLightModels.CHASSIS_MODELS[side];
    }

    private static class LanternLightModels {
        private static final CCModel BULB_MODEL;
        private static final CCModel[] CHASSIS_MODELS;

        private LanternLightModels() {
        }

        static {
            CHASSIS_MODELS = new CCModel[6];
            Map<String, CCModel> models = MultipartLightProperties.parseCorrectedModel("lantern");
            CCModel bulb = models.get("bulb");
            CCModel body = models.get("body");
            CCModel top = models.get("standtop");
            CCModel topRing = models.get("goldringtop");
            CCModel bottom = models.get("standbottom");
            CCModel bottomRing = models.get("goldringbottom");
            CCModel side = models.get("standside");
            BULB_MODEL = bulb.copy();
            LanternLightModels.CHASSIS_MODELS[0] = CCModel.combine(Arrays.asList(body, bottom, bottomRing));
            LanternLightModels.CHASSIS_MODELS[1] = CCModel.combine(Arrays.asList(body, top, topRing));
            for (int s = 2; s < 6; ++s) {
                CCModel sideModel = side.copy().apply(Rotation.sideOrientation((int)0, (int)Rotation.rotationTo((int)0, (int)s)).at(Vector3.CENTER));
                CCModel ringModel = topRing.copy().apply(Rotation.sideOrientation((int)0, (int)Rotation.rotationTo((int)0, (int)s)).at(Vector3.CENTER));
                LanternLightModels.CHASSIS_MODELS[s] = CCModel.combine(Arrays.asList(body, sideModel, ringModel));
            }
            MultipartLightProperties.finishModel(BULB_MODEL);
            for (CCModel m : CHASSIS_MODELS) {
                MultipartLightProperties.finishModel(m);
            }
        }
    }
}

