/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import java.util.Collection;
import java.util.function.Consumer;
import mrtjp.projectred.core.CoreNetwork;
import mrtjp.projectred.core.tile.IBlockEventTile;
import net.minecraft.server.level.ServerPlayer;

public interface IPacketReceiverTile
extends IBlockEventTile {
    default public void sendUpdateToServer(int key, Consumer<MCDataOutput> writer) {
        PacketCustom packet = CoreNetwork.createTileServerPacket(this, (byte)key);
        writer.accept((MCDataOutput)packet);
        packet.sendToServer();
    }

    default public void sendUpdateToPlayersWatchingChunk(int key, Consumer<MCDataOutput> writer) {
        PacketCustom packet = CoreNetwork.createTileClientPacket(this, (byte)key);
        writer.accept((MCDataOutput)packet);
        packet.sendToChunk(this.getBlockLevel(), this.getBlockPosition());
    }

    default public void sendUpdateToPlayer(int key, Consumer<MCDataOutput> writer, ServerPlayer player) {
        PacketCustom packet = CoreNetwork.createTileClientPacket(this, (byte)key);
        writer.accept((MCDataOutput)packet);
        packet.sendToPlayer(player);
    }

    default public void sendUpdateToPlayerList(int key, Consumer<MCDataOutput> writer, Collection<ServerPlayer> players) {
        PacketCustom packet = CoreNetwork.createTileClientPacket(this, (byte)key);
        writer.accept((MCDataOutput)packet);
        for (ServerPlayer player : players) {
            packet.sendToPlayer(player);
        }
    }

    public void receiveUpdateFromServer(int var1, MCDataInput var2);

    public void receiveUpdateFromClient(int var1, MCDataInput var2, ServerPlayer var3);
}

