/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.lib;

import mrtjp.projectred.lib.Point;
import mrtjp.projectred.lib.Size;
import mrtjp.projectred.lib.Vec2;

public class Rect {
    public static final Rect ZERO = new Rect(Point.ZERO, Size.ZERO);
    public static final Rect INFINITE = new Rect(new Point(-1073741824, -1073741824), Size.INFINITE);
    public final Point origin;
    public final Size size;

    public Rect(Point origin, Size size) {
        this.origin = origin;
        this.size = size;
    }

    public Rect(int x, int y, int width, int height) {
        this(new Point(x, y), new Size(width, height));
    }

    public Rect(Point min, Point max) {
        this(min, new Size(max.x - min.x, max.y - min.y));
    }

    public int x() {
        return this.origin.x;
    }

    public int y() {
        return this.origin.y;
    }

    public int width() {
        return this.size.width;
    }

    public int height() {
        return this.size.height;
    }

    public int maxX() {
        return this.origin.x + this.size.width;
    }

    public int maxY() {
        return this.origin.y + this.size.height;
    }

    public Point maxPoint() {
        return new Point(this.maxX(), this.maxY());
    }

    public int midX() {
        return this.origin.x + this.size.width / 2;
    }

    public int midY() {
        return this.origin.y + this.size.height / 2;
    }

    public Point midPoint() {
        return new Point(this.midX(), this.midY());
    }

    public boolean contains(Point point) {
        return point.x >= this.origin.x && point.y >= this.origin.y && point.x <= this.maxX() && point.y <= this.maxY();
    }

    public boolean contains(Rect rect) {
        return this.contains(rect.origin) && this.contains(rect.maxPoint());
    }

    public boolean intersects(Rect rect) {
        return this.contains(rect.origin) || this.contains(rect.maxPoint()) || rect.contains(this.origin) || rect.contains(this.maxPoint());
    }

    public Rect enclose(Point p) {
        int x = Math.min(this.origin.x, p.x);
        int y = Math.min(this.origin.y, p.y);
        int w = Math.max(this.maxX(), p.x) - x;
        int h = Math.max(this.maxY(), p.y) - y;
        return new Rect(x, y, w, h);
    }

    public Rect union(Rect rect) {
        if (this.equals(ZERO)) {
            return rect;
        }
        if (rect.equals(ZERO)) {
            return this;
        }
        int x = Math.min(this.origin.x, rect.x());
        int y = Math.min(this.origin.y, rect.y());
        int w = Math.max(this.maxX(), rect.maxX()) - x;
        int h = Math.max(this.maxY(), rect.maxY()) - y;
        return new Rect(x, y, w, h);
    }

    public Rect expand(int x, int y) {
        int dw = this.width() + x < 0 ? -this.width() : x;
        int dh = this.height() + y < 0 ? -this.height() : y;
        return new Rect(this.origin.subtract(dw / 2, dh / 2), new Size(this.width() + dw, this.height() + dh));
    }

    public Rect trap(Rect rect) {
        int dx = (rect.x() < this.x() ? this.x() - rect.x() : 0) - (rect.maxX() > this.maxX() ? rect.maxX() - this.maxX() : 0);
        int dy = (rect.y() < this.y() ? this.y() - rect.y() : 0) - (rect.maxY() > this.maxY() ? rect.maxY() - this.maxY() : 0);
        return new Rect(rect.x() + dx, rect.y() + dy, rect.width(), rect.height());
    }

    public Vec2 ndc(Point p) {
        double dx = 2.0 * (double)(p.x - this.origin.x) / (double)this.width() - 1.0;
        double dy = 2.0 * (double)(p.y - this.origin.y) / (double)this.height() - 1.0;
        return new Vec2(dx, -dy);
    }
}

