/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion;

import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.PartConverter;
import codechicken.multipart.util.MultipartGenerator;
import java.util.Objects;
import mrtjp.projectred.api.Frame;
import mrtjp.projectred.api.ProjectRedAPI;
import mrtjp.projectred.expansion.ExpansionAPI;
import mrtjp.projectred.expansion.ExpansionNetwork;
import mrtjp.projectred.expansion.GraphDebugManager;
import mrtjp.projectred.expansion.MovementManager;
import mrtjp.projectred.expansion.MovementRegistry;
import mrtjp.projectred.expansion.data.ExpansionBlockStateModelProvider;
import mrtjp.projectred.expansion.data.ExpansionBlockTagsProvider;
import mrtjp.projectred.expansion.data.ExpansionItemModelProvider;
import mrtjp.projectred.expansion.data.ExpansionLanguageProvider;
import mrtjp.projectred.expansion.data.ExpansionLootTableProvider;
import mrtjp.projectred.expansion.data.ExpansionRecipeProvider;
import mrtjp.projectred.expansion.data.ExpansionSoundProvider;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.init.ExpansionClientInit;
import mrtjp.projectred.expansion.init.ExpansionCreativeModeTabs;
import mrtjp.projectred.expansion.init.ExpansionItems;
import mrtjp.projectred.expansion.init.ExpansionMenus;
import mrtjp.projectred.expansion.init.ExpansionParts;
import mrtjp.projectred.expansion.init.ExpansionSounds;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod(value="projectred_expansion")
public class ProjectRedExpansion {
    public static final String MOD_ID = "projectred_expansion";
    public static final Logger LOGGER = LogManager.getLogger((String)"projectred_expansion");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"projectred_expansion");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"projectred_expansion");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"projectred_expansion");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"projectred_expansion");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"projectred_expansion");
    public static final DeferredRegister<MultipartType<?>> PART_TYPES = DeferredRegister.create((ResourceKey)MultipartType.MULTIPART_TYPES, (String)"projectred_expansion");
    public static final DeferredRegister<PartConverter> PART_CONVERTERS = DeferredRegister.create((ResourceKey)PartConverter.PART_CONVERTERS, (String)"projectred_expansion");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"projectred_expansion");
    @Nullable
    private static ModContainer container;

    public ProjectRedExpansion(ModContainer container, IEventBus modEventBus) {
        ProjectRedExpansion.container = container;
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onGatherDataEvent);
        modEventBus.addListener(this::onRegisterCaps);
        if (FMLEnvironment.dist.isClient()) {
            ExpansionClientInit.init(modEventBus);
        }
        ExpansionNetwork.init(modEventBus);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        SOUNDS.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        MENU_TYPES.register(modEventBus);
        PART_TYPES.register(modEventBus);
        PART_CONVERTERS.register(modEventBus);
        CREATIVE_TABS.register(modEventBus);
        NeoForge.EVENT_BUS.addListener(MovementManager::onChunkWatchEvent);
        NeoForge.EVENT_BUS.addListener(MovementManager::onChunkUnwatchEvent);
        NeoForge.EVENT_BUS.addListener(MovementManager::onChunkUnloadEvent);
        NeoForge.EVENT_BUS.addListener(MovementManager::onLevelTick);
        NeoForge.EVENT_BUS.addListener(MovementManager::onLevelLoad);
        NeoForge.EVENT_BUS.addListener(MovementManager::onLevelUnload);
        NeoForge.EVENT_BUS.addListener(GraphDebugManager::onLevelUnload);
        NeoForge.EVENT_BUS.addListener(GraphDebugManager::onLevelTick);
        NeoForge.EVENT_BUS.addListener(GraphDebugManager::registerClientCommands);
    }

    public static ModContainer getContainer() {
        return Objects.requireNonNull(container);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        MultipartGenerator.INSTANCE.registerPassThroughInterface(Frame.class);
        MovementRegistry.init();
    }

    private void onGatherDataEvent(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new ExpansionBlockStateModelProvider(output, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ExpansionItemModelProvider(output, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ExpansionLanguageProvider(output));
        generator.addProvider(event.includeClient(), (DataProvider)new ExpansionSoundProvider(output, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ExpansionBlockTagsProvider(output, event.getLookupProvider(), fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ExpansionRecipeProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new ExpansionLootTableProvider(output));
    }

    public void onRegisterCaps(RegisterCapabilitiesEvent event) {
        ExpansionBlocks.registerCaps(event);
    }

    static {
        ProjectRedAPI.expansionAPI = ExpansionAPI.INSTANCE;
        ExpansionBlocks.register();
        ExpansionMenus.register();
        ExpansionItems.register();
        ExpansionSounds.register();
        ExpansionParts.register();
        ExpansionCreativeModeTabs.register();
    }
}

