/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.block;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.tile.BatteryBoxBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class BatteryBoxBlock
extends ProjectRedBlock {
    public static final IntegerProperty CHARGE_LEVEL = IntegerProperty.create((String)"charge_level", (int)0, (int)8);

    public BatteryBoxBlock() {
        super(WOODEN_PROPERTIES);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BatteryBoxBlockEntity(pos, state);
    }

    protected BlockEntityType<?> getBlockEntityType() {
        return ExpansionBlocks.BATTERY_BOX_BLOCK_ENTITY.get();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)CHARGE_LEVEL, (Comparable)Integer.valueOf(0));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CHARGE_LEVEL});
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity tile = (BlockEntity)builder.getParameter(LootContextParams.BLOCK_ENTITY);
        if (tile instanceof BatteryBoxBlockEntity) {
            BatteryBoxBlockEntity batteryBoxTile = (BatteryBoxBlockEntity)tile;
            return Collections.singletonList(batteryBoxTile.createStackWithStoredPower());
        }
        return super.getDrops(state, builder);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof BatteryBoxBlockEntity) {
            return ((BatteryBoxBlockEntity)tile).createStackWithStoredPower();
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter level, List<Component> toolTip, TooltipFlag flag) {
        super.appendHoverText(stack, level, toolTip, flag);
        if (stack.hasTag()) {
            int power = Objects.requireNonNull(stack.getTag()).getInt("power_stored");
            toolTip.add((Component)Component.translatable((String)"projectred-expansion.tooltip.charge_level").append(": " + power + " / 8000").withStyle(ChatFormatting.GRAY));
        }
    }
}

