/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.graphs;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import mrtjp.projectred.expansion.graphs.GraphLink;
import mrtjp.projectred.expansion.graphs.GraphNode;
import mrtjp.projectred.expansion.graphs.GraphRoute;
import mrtjp.projectred.expansion.graphs.GraphRouteEdge;
import mrtjp.projectred.expansion.graphs.GraphRouteTable;

public class GraphRoutePathfinder {
    private final Queue<GraphRoute> open = new PriorityQueue<GraphRoute>(Comparator.comparingInt(GraphRoute::weight));
    private final HashSet<GraphRoute> openSet = new HashSet();
    private final HashSet<GraphRoute> closedSet = new HashSet();
    private final HashMap<GraphNode, List<GraphRoute>> routeMap = new HashMap();
    private final HashMap<Integer, List<GraphRoute>> directionMap = new HashMap();
    private final List<GraphRoute> routes = new LinkedList<GraphRoute>();
    private final List<GraphNode> destinations = new LinkedList<GraphNode>();
    private final Set<GraphNode> destinationSet = new HashSet<GraphNode>();

    public GraphRoutePathfinder(GraphNode startNode) {
        this.openInitial(startNode);
    }

    private void openInitial(GraphNode startNode) {
        for (GraphLink link : startNode.getLinks()) {
            GraphRoute route = GraphRoutePathfinder.beginRoute(startNode, link.to().getNode(), link.direction(), link.weight());
            this.open.add(route);
            this.openSet.add(route);
        }
    }

    private void openNext(GraphRoute prev) {
        if (this.isRouteRedundant(prev)) {
            return;
        }
        this.routeMap.computeIfAbsent(prev.end(), k -> new LinkedList()).add(prev);
        this.directionMap.computeIfAbsent(prev.direction(), k -> new LinkedList()).add(prev);
        this.routes.add(prev);
        if (!this.destinationSet.contains(prev.end())) {
            this.destinations.add(prev.end());
        }
        for (GraphLink link : prev.end().getLinks()) {
            GraphRoute next = GraphRoutePathfinder.appendToRoute(prev, link.to().getNode(), link.direction(), link.weight());
            if (this.openSet.contains(next) || this.closedSet.contains(next)) continue;
            this.open.add(next);
            this.openSet.add(next);
        }
    }

    public void step() {
        if (this.open.isEmpty()) {
            return;
        }
        GraphRoute next = this.open.poll();
        this.openSet.remove(next);
        this.openNext(next);
        this.closedSet.add(next);
    }

    public boolean isFinished() {
        return this.open.isEmpty();
    }

    private boolean isRouteRedundant(GraphRoute path) {
        if (path.end() == path.start()) {
            return true;
        }
        List<GraphRoute> prevRoute = this.routeMap.get(path.end());
        if (prevRoute != null) {
            for (GraphRoute prevPath : prevRoute) {
                if (prevPath.weight() > path.weight()) continue;
                return true;
            }
        }
        return false;
    }

    public GraphRouteTable result() {
        while (!this.isFinished()) {
            this.step();
        }
        return new GraphRouteTable(this.routeMap, this.directionMap, this.destinations, this.routes);
    }

    private static GraphRoute beginRoute(GraphNode start, GraphNode end, int dir, int weight) {
        return new GraphRoute(start, end, weight, List.of(new GraphRouteEdge(start, end, dir, weight)));
    }

    private static GraphRoute appendToRoute(GraphRoute route, GraphNode next, int dir, int weight) {
        LinkedList<GraphRouteEdge> newEdges = new LinkedList<GraphRouteEdge>(route.edges());
        newEdges.add(new GraphRouteEdge(route.end(), next, dir, weight));
        return new GraphRoute(route.start(), next, route.weight() + weight, newEdges);
    }
}

