/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.gui.screen.inventory;

import codechicken.lib.colour.EnumColour;
import mrtjp.projectred.expansion.inventory.container.AutoCrafterMenu;
import mrtjp.projectred.expansion.item.RecipePlanItem;
import mrtjp.projectred.lib.GuiLib;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.AbstractButtonNode;
import mrtjp.projectred.redui.RedUIContainerScreen;
import mrtjp.projectred.redui.RedUINode;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class AutoCrafterScreen
extends RedUIContainerScreen<AutoCrafterMenu> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("projectred_expansion", "textures/gui/auto_crafter.png");
    private boolean isShiftDown = false;

    public AutoCrafterScreen(AutoCrafterMenu container, Inventory playerInventory, Component title) {
        super(176, 212, (AbstractContainerMenu)container, playerInventory, title);
        this.inventoryLabelX = 8;
        this.inventoryLabelY = 120;
        this.initSubNodes();
    }

    private void initSubNodes() {
        AbstractButtonNode cyclePlanButton = new AbstractButtonNode(){

            protected void onButtonClicked() {
                ((AutoCrafterMenu)AutoCrafterScreen.this.getMenu()).getAutoCrafterTile().sendCyclePlan();
            }

            protected void drawButtonBody(GuiGraphics graphics, boolean mouseover) {
                graphics.blit(BACKGROUND, this.getPosition().x, this.getPosition().y, 176, 0, 14, 14);
            }
        };
        cyclePlanButton.setPosition(126, 23);
        cyclePlanButton.setSize(14, 14);
        this.addChild((RedUINode)cyclePlanButton);
    }

    public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
        super.drawBack(graphics, mouse, partialFrame);
        int x = this.getFrame().x();
        int y = this.getFrame().y();
        graphics.blit(BACKGROUND, x, y, 0, 0, this.getFrame().width(), this.getFrame().height());
        if (((AutoCrafterMenu)this.getMenu()).canConductorWork()) {
            graphics.blit(BACKGROUND, x + 16, y + 16, 177, 18, 7, 9);
        }
        GuiLib.drawVerticalTank((GuiGraphics)graphics, (ResourceLocation)BACKGROUND, (int)(x + 16), (int)(y + 26), (int)177, (int)27, (int)7, (int)48, (int)((AutoCrafterMenu)this.getMenu()).getChargeScaled(48));
        if (((AutoCrafterMenu)this.getMenu()).isFlowFull()) {
            graphics.blit(BACKGROUND, x + 27, y + 16, 185, 18, 7, 9);
        }
        GuiLib.drawVerticalTank((GuiGraphics)graphics, (ResourceLocation)BACKGROUND, (int)(x + 27), (int)(y + 26), (int)185, (int)27, (int)7, (int)48, (int)((AutoCrafterMenu)this.getMenu()).getFlowScaled(48));
        int s = ((AutoCrafterMenu)this.getMenu()).getProgressScaled(22);
        graphics.blit(BACKGROUND, x + 100, y + 41, 193, 23, s + 1, 14);
        ItemStack output = ((AutoCrafterMenu)this.getMenu()).getPlanOutput();
        if (!output.isEmpty()) {
            graphics.renderItem(output, x + 125, y + 40);
        }
    }

    public void drawFront(GuiGraphics graphics, Point mouse, float partialFrame) {
        if (this.isShiftDown) {
            this.drawPlanOutputsOverlay(graphics, this.getFrame().x(), this.getFrame().y());
        }
        this.drawPlanSlotSelection(graphics, this.getFrame().x() + 44, this.getFrame().y() + 22);
    }

    private void drawPlanSlotSelection(GuiGraphics graphics, int xPos, int yPos) {
        int s = ((AutoCrafterMenu)this.getMenu()).getPlanSlot();
        int ix = s % 3;
        int iy = s / 3;
        int x = xPos + 18 * ix - 3;
        int y = yPos + 18 * iy - 3;
        graphics.blit(BACKGROUND, x, y, 193, 0, 22, 22);
    }

    private void drawPlanOutputsOverlay(GuiGraphics graphics, int xPos, int yPos) {
        for (Slot slot : ((AutoCrafterMenu)this.getMenu()).slots) {
            ItemStack stack = slot.getItem();
            if (!RecipePlanItem.hasRecipeInside(stack)) continue;
            ItemStack output = RecipePlanItem.loadPlanOutput(stack);
            int colour = EnumColour.LIGHT_BLUE.argb(204);
            graphics.fillGradient(xPos + slot.x, yPos + slot.y, xPos + slot.x + 16, yPos + slot.y + 16, colour, colour);
            graphics.renderItem(output, xPos + slot.x, yPos + slot.y, 0, 200);
        }
    }

    public boolean onKeyPressed(int glfwKeyCode, int glfwScanCode, int glfwFlags, boolean consumed) {
        if (!consumed && glfwKeyCode == 340) {
            this.isShiftDown = true;
            return true;
        }
        return false;
    }

    public boolean onKeyReleased(int glfwKeyCode, int glfwScanCode, int glfwFlags, boolean consumed) {
        if (glfwKeyCode == 340) {
            this.isShiftDown = false;
            return true;
        }
        return false;
    }
}

