/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.gui.screen.inventory;

import codechicken.lib.colour.EnumColour;
import com.mojang.blaze3d.systems.RenderSystem;
import mrtjp.projectred.expansion.inventory.container.ProjectBenchMenu;
import mrtjp.projectred.expansion.item.RecipePlanItem;
import mrtjp.projectred.expansion.tile.ProjectBenchBlockEntity;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.AbstractButtonNode;
import mrtjp.projectred.redui.RedUIContainerScreen;
import mrtjp.projectred.redui.RedUINode;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ProjectBenchScreen
extends RedUIContainerScreen<ProjectBenchMenu> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("projectred_expansion", "textures/gui/project_bench.png");
    private boolean isShiftDown = false;

    public ProjectBenchScreen(ProjectBenchMenu container, Inventory playerInventory, Component title) {
        super(176, 208, (AbstractContainerMenu)container, playerInventory, title);
        this.inventoryLabelX = 8;
        this.inventoryLabelY = 116;
        this.initSubNodes();
    }

    private void initSubNodes() {
        AbstractButtonNode writePlanButton = new AbstractButtonNode(){

            protected void onButtonClicked() {
                ((ProjectBenchMenu)ProjectBenchScreen.this.getMenu()).getProjectBenchTile().sendWriteButtonPressed();
            }

            protected void drawButtonBody(GuiGraphics graphics, boolean mouseover) {
                graphics.blit(BACKGROUND, this.getPosition().x, this.getPosition().y, 176, 0, 14, 14);
            }
        };
        writePlanButton.setPosition(18, 56);
        writePlanButton.setSize(14, 14);
        this.addChild((RedUINode)writePlanButton);
        AbstractButtonNode clearGridButton = new AbstractButtonNode(){

            protected void onButtonClicked() {
                ((ProjectBenchMenu)ProjectBenchScreen.this.getMenu()).getProjectBenchTile().sendGridClearButtonPressed();
            }

            protected void drawButtonBody(GuiGraphics graphics, boolean mouseover) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
                graphics.blit(BACKGROUND, this.getPosition().x, this.getPosition().y, 176, 15, 8, 8);
            }
        };
        clearGridButton.setPosition(37, 17);
        clearGridButton.setSize(8, 8);
        this.addChild((RedUINode)clearGridButton);
    }

    public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
        int x = this.getFrame().x();
        int y = this.getFrame().y();
        graphics.blit(BACKGROUND, x, y, 0, 0, this.getFrame().width(), this.getFrame().height());
        ProjectBenchBlockEntity tile = ((ProjectBenchMenu)this.getMenu()).getProjectBenchTile();
        if (tile.isPlanRecipe()) {
            int missingMask = tile.getCraftingHelper().getMissingIngredientMask();
            CraftingContainer inputs = tile.getCraftingHelper().getCraftingInventory();
            this.drawPlanIngredientsOverlay(graphics, (Container)inputs, missingMask, x + 48, y + 18);
        }
    }

    public void drawFront(GuiGraphics graphics, Point mouse, float partialFrame) {
        if (this.isShiftDown) {
            this.drawPlanOutputsOverlay(graphics, this.getFrame().x(), this.getFrame().y());
        }
    }

    private void drawPlanIngredientsOverlay(GuiGraphics graphics, Container ingredients, int missingMask, int xPos, int yPos) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int colour;
                int drawPosX = xPos + x * 18;
                int drawPosY = yPos + y * 18;
                int index = y * 3 + x;
                ItemStack ingredient = ingredients.getItem(index);
                int n = colour = (missingMask & 1 << index) != 0 ? EnumColour.RED.argb(119) : EnumColour.GRAY.argb(119);
                if (ingredient.isEmpty()) continue;
                graphics.fillGradient(drawPosX, drawPosY, drawPosX + 16, drawPosY + 16, colour, colour);
                graphics.renderItem(ingredient, drawPosX, drawPosY);
            }
        }
    }

    private void drawPlanOutputsOverlay(GuiGraphics graphics, int xPos, int yPos) {
        for (Slot slot : ((ProjectBenchMenu)this.getMenu()).slots) {
            ItemStack stack = slot.getItem();
            if (!RecipePlanItem.hasRecipeInside(stack)) continue;
            ItemStack output = RecipePlanItem.loadPlanOutput(stack);
            int colour = EnumColour.LIGHT_BLUE.argb(204);
            graphics.fillGradient(xPos + slot.x, yPos + slot.y, xPos + slot.x + 16, yPos + slot.y + 16, colour, colour);
            graphics.renderItem(output, xPos + slot.x, yPos + slot.y, 0, 200);
        }
    }

    public boolean onKeyPressed(int glfwKeyCode, int glfwScanCode, int glfwFlags, boolean consumed) {
        if (!consumed && glfwKeyCode == 340) {
            this.isShiftDown = true;
            return true;
        }
        return false;
    }

    public boolean onKeyReleased(int glfwKeyCode, int glfwScanCode, int glfwFlags, boolean consumed) {
        if (glfwKeyCode == 340) {
            this.isShiftDown = false;
            return true;
        }
        return false;
    }
}

