/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.inventory.container;

import codechicken.lib.inventory.container.ICCLContainerFactory;
import mrtjp.projectred.core.inventory.container.BasePoweredBlockEntityMenu;
import mrtjp.projectred.core.inventory.container.SimpleDataSlot;
import mrtjp.projectred.core.tile.BasePoweredBlockEntity;
import mrtjp.projectred.expansion.init.ExpansionMenus;
import mrtjp.projectred.expansion.item.IChargable;
import mrtjp.projectred.expansion.item.IRechargableBattery;
import mrtjp.projectred.expansion.tile.BatteryBoxBlockEntity;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BatteryBoxMenu
extends BasePoweredBlockEntityMenu {
    public static final ICCLContainerFactory<BatteryBoxMenu> FACTORY = (windowId, inventory, packet) -> {
        BlockEntity tile = inventory.player.level().getBlockEntity(packet.readPos());
        if (!(tile instanceof BatteryBoxBlockEntity)) {
            return null;
        }
        return new BatteryBoxMenu(inventory, (BatteryBoxBlockEntity)tile, windowId);
    };
    private final Inventory playerInventory;
    private final BatteryBoxBlockEntity tile;
    protected int powerStored = 0;

    public BatteryBoxMenu(Inventory inventory, BatteryBoxBlockEntity tile, int windowId) {
        super(ExpansionMenus.BATTERY_BOX_MENU.get(), windowId, (BasePoweredBlockEntity)tile);
        this.playerInventory = inventory;
        this.tile = tile;
        InventoryLib.addPlayerInventory((Inventory)inventory, (int)8, (int)89, x$0 -> this.addSlot((Slot)x$0));
        this.addBatteryBoxInventory();
        this.addDataSlot((DataSlot)new SimpleDataSlot(tile::getPowerStored, value -> {
            this.powerStored = value;
        }));
    }

    private void addBatteryBoxInventory() {
        this.addSlot(new BatterySlot(this.tile.getInventory(), 0, 80, 31));
        this.addSlot(new BatterySlot(this.tile.getInventory(), 1, 80, 53));
    }

    public boolean stillValid(Player pPlayer) {
        return Container.stillValidBlockEntity((BlockEntity)this.tile, (Player)pPlayer);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack originalStack = stack.copy();
        if (this.isStorage(slotIndex)) {
            if (!this.moveToEntireInventory(stack, true)) {
                return ItemStack.EMPTY;
            }
        } else if (stack.getItem() instanceof IChargable) {
            boolean itemHasPower = ((IChargable)stack.getItem()).getStoredPower(stack) > 0;
            boolean tileHasSpace = this.tile.getPowerStored() < this.tile.getMaxStorage();
            if (!this.moveToStorage(stack, itemHasPower && tileHasSpace)) {
                return ItemStack.EMPTY;
            }
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stack.getCount() == originalStack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stack);
        return originalStack;
    }

    public int getPowerStoredScaled(int scale) {
        return Math.min(scale, scale * this.powerStored / this.tile.getMaxStorage());
    }

    public boolean isPowerStorageFull() {
        return this.powerStored == this.tile.getMaxStorage();
    }

    public boolean isStorageCharging() {
        return this.condCharge > this.tile.getConductorUpperChargeTarget() && this.powerStored < this.tile.getMaxStorage();
    }

    public boolean isStorageDischarging() {
        return this.condCharge < this.tile.getConductorLowerChargeTarget() && this.powerStored > 0;
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isStorage(int slotIndex) {
        return slotIndex >= 36 && slotIndex < 38;
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 27, reverse);
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 27, 36, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 36, reverse);
    }

    private boolean moveToStorage(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 36, 38, reverse);
    }

    private static class BatterySlot
    extends Slot {
        public BatterySlot(Container inventory, int slot, int x, int y) {
            super(inventory, slot, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return stack.getItem() instanceof IRechargableBattery;
        }
    }
}

