/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.inventory.container;

import codechicken.lib.inventory.container.ICCLContainerFactory;
import mrtjp.projectred.expansion.init.ExpansionMenus;
import mrtjp.projectred.expansion.item.RecipePlanItem;
import mrtjp.projectred.expansion.tile.ProjectBenchBlockEntity;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ProjectBenchMenu
extends AbstractContainerMenu {
    public static final ICCLContainerFactory<ProjectBenchMenu> FACTORY = (windowId, playerInv, packet) -> {
        BlockEntity tile = playerInv.player.level().getBlockEntity(packet.readPos());
        if (!(tile instanceof ProjectBenchBlockEntity)) {
            return null;
        }
        return new ProjectBenchMenu(playerInv, (ProjectBenchBlockEntity)tile, windowId);
    };
    private final ProjectBenchBlockEntity tile;
    private final Inventory playerInventory;

    public ProjectBenchMenu(Inventory playerInventory, ProjectBenchBlockEntity tile, int windowId) {
        super(ExpansionMenus.PROJECT_BENCH_MENU.get(), windowId);
        this.playerInventory = playerInventory;
        this.tile = tile;
        InventoryLib.addPlayerInventory((Inventory)playerInventory, (int)8, (int)126, x$0 -> this.addSlot((Slot)x$0));
        this.addProjectBenchInventory();
    }

    private void addProjectBenchInventory() {
        InventoryLib.addInventory((Container)this.tile.getStorageInventory(), (int)0, (int)8, (int)76, (int)9, (int)2, x$0 -> this.addSlot((Slot)x$0));
        InventoryLib.addInventory((Container)this.tile.getCraftingGridInventory(), (int)0, (int)48, (int)18, (int)3, (int)3, x$0 -> this.addSlot((Slot)x$0));
        this.addSlot((Slot)new ProjectBenchCraftingSlot(143, 36));
        this.addSlot(new Slot((Container)this.tile.getPlanInventory(), 0, 17, 36){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() instanceof RecipePlanItem;
            }

            public int getMaxStackSize() {
                return 1;
            }
        });
    }

    public ProjectBenchBlockEntity getProjectBenchTile() {
        return this.tile;
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this.tile, (Player)player);
    }

    protected void addPlayerInventory(Inventory playerInventory, int x, int y) {
        this.addInventory((Container)playerInventory, 9, x, y, 9, 3);
        this.addInventory((Container)playerInventory, 0, x, y + 58, 9, 1);
    }

    protected void addInventory(Container inventory, int i, int x, int y, int columns, int rows) {
        for (int c = 0; c < columns; ++c) {
            for (int r = 0; r < rows; ++r) {
                this.addSlot(new Slot(inventory, i + (r * columns + c), x + c * 18, y + r * 18));
            }
        }
    }

    public void transferAllFromGrid() {
        for (int i = 0; i < 9; ++i) {
            int craftingGridSlot = i + 54;
            if (!this.getSlot(craftingGridSlot).hasItem()) continue;
            this.quickMoveStack(this.playerInventory.player, craftingGridSlot);
        }
        this.broadcastChanges();
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack originalStack = stack.copy();
        if (this.isCraftingGrid(slotIndex)) {
            if (!this.moveToStorage(stack, false) && !this.moveToEntireInventory(stack, false)) {
                return ItemStack.EMPTY;
            }
        } else if (this.isStorage(slotIndex)) {
            if (stack.getItem() instanceof RecipePlanItem) {
                if (!this.getSlot(64).getItem().isEmpty()) {
                    this.quickMoveStack(player, 64);
                }
                if (!this.moveToPlanSlot(stack, false) && !this.moveToEntireInventory(stack, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (!this.moveToEntireInventory(stack, false)) {
                return ItemStack.EMPTY;
            }
        } else if (this.isPlanSlot(slotIndex)) {
            if (!this.moveToStorage(stack, true) && !this.moveToEntireInventory(stack, false)) {
                return ItemStack.EMPTY;
            }
        } else if (this.isResultSlot(slotIndex)) {
            if (!slot.mayPickup(player)) {
                return ItemStack.EMPTY;
            }
            if (!this.moveToEntireInventory(stack, true) && !this.moveToStorage(stack, true)) {
                return ItemStack.EMPTY;
            }
        } else if (this.isPlayerInventory(slotIndex) || this.isHotbar(slotIndex)) {
            if (stack.getItem() instanceof RecipePlanItem) {
                if (!this.getSlot(64).getItem().isEmpty()) {
                    this.quickMoveStack(player, 64);
                }
                if (!this.moveToPlanSlot(stack, false) && !this.moveToStorage(stack, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.isPlayerInventory(slotIndex) ? !this.moveToStorage(stack, false) && !this.moveToHotbar(stack, false) : !this.moveToPlayerInventory(stack, false)) {
                return ItemStack.EMPTY;
            }
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stack.getCount() == originalStack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stack);
        return originalStack;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.container != this.tile.getCraftingHelper().getCraftResultInventory();
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isStorage(int slotIndex) {
        return slotIndex >= 36 && slotIndex < 54;
    }

    private boolean isCraftingGrid(int slotIndex) {
        return slotIndex >= 54 && slotIndex < 63;
    }

    private boolean isResultSlot(int slotIndex) {
        return slotIndex == 63;
    }

    private boolean isPlanSlot(int slotIndex) {
        return slotIndex == 64;
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 27, reverse);
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 27, 36, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 36, reverse);
    }

    private boolean moveToStorage(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 36, 54, reverse);
    }

    private boolean moveToCraftingGrid(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 54, 63, reverse);
    }

    private boolean moveToPlanSlot(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 64, 65, reverse);
    }

    private class ProjectBenchCraftingSlot
    extends ResultSlot {
        public ProjectBenchCraftingSlot(int x, int y) {
            super(ProjectBenchMenu.this.playerInventory.player, ProjectBenchMenu.this.tile.getCraftingHelper().getCraftingInventory(), (Container)ProjectBenchMenu.this.tile.getCraftingHelper().getCraftResultInventory(), 0, x, y);
        }

        public boolean mayPickup(Player player) {
            return ProjectBenchMenu.this.tile.getCraftingHelper().canTake();
        }

        public void onTake(Player player, ItemStack stack) {
            this.checkTakeAchievements(stack);
            ProjectBenchMenu.this.tile.getCraftingHelper().onCraftedByPlayer(player, !ProjectBenchMenu.this.tile.isPlanRecipe());
            ProjectBenchMenu.this.tile.updateRecipeIfNeeded();
        }
    }
}

