/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.item;

import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;

public interface IChargable {
    default public Tuple<ItemStack, Integer> addPower(ItemStack stack, int power) {
        if (stack.getItem() != this) {
            return new Tuple((Object)stack, (Object)0);
        }
        if (this.getChargedVariant() != this.getEmptyVariant() && stack.getItem() == this.getChargedVariant() && stack.getDamageValue() == 0) {
            return new Tuple((Object)stack, (Object)0);
        }
        if (this.getChargedVariant() != this.getEmptyVariant() && stack.getItem() == this.getEmptyVariant()) {
            ItemStack chargedStack = new ItemStack((ItemLike)this.getChargedVariant(), 1);
            chargedStack.setTag(stack.getTag());
            chargedStack.setDamageValue(chargedStack.getMaxDamage());
            stack = chargedStack;
        }
        int spaceLeft = stack.getDamageValue();
        int toAdd = Math.min(spaceLeft, power);
        stack.setDamageValue(stack.getDamageValue() - toAdd);
        return new Tuple((Object)stack, (Object)toAdd);
    }

    default public Tuple<ItemStack, Integer> drawPower(ItemStack stack, int power) {
        if (stack.getItem() != this) {
            return new Tuple((Object)stack, (Object)0);
        }
        if (this.getChargedVariant() != this.getEmptyVariant() && stack.getItem() == this.getEmptyVariant()) {
            return new Tuple((Object)stack, (Object)0);
        }
        int powerLeft = stack.getMaxDamage() - stack.getDamageValue();
        int toDraw = Math.min(powerLeft, power);
        stack.setDamageValue(stack.getDamageValue() + toDraw);
        if (this.getChargedVariant() != this.getEmptyVariant() && stack.getDamageValue() >= stack.getMaxDamage()) {
            ItemStack emptyStack;
            stack = emptyStack = new ItemStack((ItemLike)this.getEmptyVariant(), 1);
        }
        return new Tuple((Object)stack, (Object)toDraw);
    }

    default public int getStoredPower(ItemStack stack) {
        if (stack.getItem() != this) {
            return 0;
        }
        if (stack.getItem() == this.getEmptyVariant()) {
            return 0;
        }
        return stack.getMaxDamage() - stack.getDamageValue();
    }

    default public boolean isFullyCharged(ItemStack stack) {
        return stack.getItem() == this.getChargedVariant() && stack.getDamageValue() == 0;
    }

    default public boolean canApplyElectricEnchantment(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public Item getChargedVariant();

    public Item getEmptyVariant();
}

