/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.TickablePart;
import codechicken.multipart.block.TileMultipart;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.CenterLookup;
import mrtjp.projectred.core.client.particle.ParticleAction;
import mrtjp.projectred.expansion.ProjectRedExpansion;
import mrtjp.projectred.expansion.TubeType;
import mrtjp.projectred.expansion.client.PneumaticSmokeParticle;
import mrtjp.projectred.expansion.graphs.ClientSideLinkCache;
import mrtjp.projectred.expansion.graphs.GraphContainer;
import mrtjp.projectred.expansion.init.ExpansionSounds;
import mrtjp.projectred.expansion.part.GraphContainerTubePart;
import mrtjp.projectred.expansion.part.PneumaticTubePayload;
import mrtjp.projectred.expansion.pneumatics.PneumaticExitPathfinder;
import mrtjp.projectred.expansion.pneumatics.PneumaticTransport;
import mrtjp.projectred.expansion.pneumatics.PneumaticTransportContainer;
import mrtjp.projectred.expansion.pneumatics.PneumaticTransportDevice;
import mrtjp.projectred.expansion.pneumatics.PneumaticTransportMode;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class PneumaticTubePart
extends GraphContainerTubePart
implements PneumaticTransportContainer,
GraphContainer,
TickablePart {
    private static final int KEY_NEW_PAYLOAD = 16;
    private static final int KEY_PAYLOAD_UPDATE = 17;
    private static final int KEY_PAYLOAD_HANDOFF = 18;
    private static final int KEY_PAYLOAD_REMOVE = 19;
    private static final int KEY_NODE_LINKS_UPDATE = 20;
    private static final int KEY_NODE_STATE_UPDATE = 21;
    public final ClientSideLinkCache linkCache = new ClientSideLinkCache();
    private final PneumaticTransport transport = new PneumaticTransport(this);
    private int lastRoundRobinDir = -1;

    public PneumaticTubePart(TubeType pipeType) {
        super(pipeType);
        if (FMLEnvironment.dist.isClient()) {
            this.linkCache.setRemovedCallback(this::onLinksRemoved);
            this.linkCache.setAddedCallback(this::onLinksAdded);
        }
    }

    @Override
    public PneumaticTransport getPneumaticTransport() {
        return this.transport;
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.putByte("last_dir", (byte)this.lastRoundRobinDir);
        this.transport.save(tag);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.lastRoundRobinDir = tag.getByte("last_dir");
        this.transport.load(tag);
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        this.transport.writeDesc(packet);
        this.linkCache.writeDesc(packet);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.transport.readDesc(packet);
        this.linkCache.readDesc(packet);
    }

    @Override
    protected void read(MCDataInput packet, int key) {
        switch (key) {
            case 16: {
                int id = packet.readInt();
                PneumaticTubePayload payload = new PneumaticTubePayload();
                payload.readDesc(packet);
                this.transport.addPayload(id, payload);
                break;
            }
            case 17: {
                int id = packet.readInt();
                PneumaticTubePayload payload = this.transport.getPayload(id);
                if (payload == null) {
                    ProjectRedExpansion.LOGGER.warn("Pneumatic tube got update for non-existent payload");
                    payload = new PneumaticTubePayload();
                }
                payload.readDesc(packet);
                break;
            }
            case 18: {
                this.readPayloadHandoff(packet);
                break;
            }
            case 19: {
                this.readPayloadRemoved(packet);
                break;
            }
            case 20: {
                this.linkCache.readLinkUpdate(packet);
                break;
            }
            case 21: {
                this.linkCache.readStateUpdate(packet);
                break;
            }
            default: {
                super.read(packet, key);
            }
        }
    }

    private void sendNewPayload(int id, PneumaticTubePayload payload) {
        this.sendUpdate(16, out -> {
            out.writeInt(id);
            payload.writeDesc((MCDataOutput)out);
        });
    }

    private void sendPayloadUpdate(int id, PneumaticTubePayload payload) {
        this.sendUpdate(17, out -> {
            out.writeInt(id);
            payload.writeDesc((MCDataOutput)out);
        });
    }

    private void sendPayloadHandoff(int id, PneumaticTubePayload payload, int newId, int dir) {
        this.sendUpdate(18, out -> {
            out.writeInt(id);
            payload.writeDesc((MCDataOutput)out);
            out.writeInt(newId);
            out.writeByte(dir);
        });
    }

    private void sendPayloadRemoved(Collection<Integer> ids) {
        this.sendUpdate(19, out -> {
            out.writeInt(ids.size());
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                out.writeInt(id);
            }
        });
    }

    private void sendNodeLinkUpdate() {
        this.sendUpdate(20, this.linkCache::writeLinkUpdate);
    }

    private void sendNodeStateUpdate() {
        this.sendUpdate(21, this.linkCache::writeStateUpdate);
    }

    private void readPayloadHandoff(MCDataInput packet) {
        int id = packet.readInt();
        PneumaticTubePayload payload = this.transport.removePayload(id);
        if (payload == null) {
            ProjectRedExpansion.LOGGER.warn("Pneumatic tube got handoff for non-existent payload");
            payload = new PneumaticTubePayload();
        }
        payload.readDesc(packet);
        int newId = packet.readInt();
        short side = packet.readUByte();
        CenterLookup lookup = CenterLookup.lookupStraightCenter((Level)this.level(), (BlockPos)this.pos(), (int)side);
        MultiPart multiPart = lookup.part;
        if (multiPart instanceof PneumaticTransportContainer) {
            PneumaticTransportContainer ptc = (PneumaticTransportContainer)multiPart;
            ptc.getPneumaticTransport().addPayload(newId, payload);
        }
    }

    private void readPayloadRemoved(MCDataInput packet) {
        int count = packet.readInt();
        for (int i = 0; i < count; ++i) {
            this.transport.removePayload(packet.readInt());
        }
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        if (!this.level().isClientSide) {
            for (PneumaticTubePayload i : this.transport.getPayloads()) {
                TileMultipart.dropItem((ItemStack)i.getItemStack(), (Level)this.level(), (Vector3)Vector3.fromTileCenter((BlockEntity)this.tile()));
            }
        }
    }

    @Override
    public void maskChangeEvent(boolean internalChange, boolean externalChange) {
        super.maskChangeEvent(internalChange, externalChange);
        if (internalChange || externalChange) {
            Collection<Integer> removed = this.transport.removePayloadsConditionally(p -> {
                if (!this.maskConnects(p.getCurrentSide())) {
                    TileMultipart.dropItem((ItemStack)p.getItemStack(), (Level)this.level(), (Vector3)Vector3.fromTileCenter((BlockEntity)this.tile()));
                    return true;
                }
                return false;
            });
            this.sendPayloadRemoved(removed);
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.transport.tick();
    }

    @Override
    protected void onRemovalSeveredLink() {
        super.onRemovalSeveredLink();
        this.level().playSound(null, this.pos(), ExpansionSounds.DEPRESSURIZE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public boolean canConnectPart(IConnectable part, int s) {
        if (part instanceof PneumaticTransportContainer) {
            return true;
        }
        return super.canConnectPart(part, s);
    }

    @Override
    public boolean discoverStraightOverride(int s) {
        return this.hasEndpointOnSide(s);
    }

    private boolean hasEndpointOnSide(int s) {
        CenterLookup lookup = CenterLookup.lookupStraightCenter((Level)this.level(), (BlockPos)this.pos(), (int)s);
        if (lookup.tile == null) {
            return false;
        }
        BlockEntity blockEntity = lookup.tile;
        if (blockEntity instanceof PneumaticTransportDevice) {
            PneumaticTransportDevice p = (PneumaticTransportDevice)blockEntity;
            return p.canConnectTube(lookup.otherDirection);
        }
        blockEntity = lookup.tile;
        if (blockEntity instanceof WorldlyContainer) {
            WorldlyContainer wc = (WorldlyContainer)blockEntity;
            return wc.getSlotsForFace(Direction.values()[lookup.otherDirection]).length > 0;
        }
        IItemHandler itemCap = (IItemHandler)this.level().getCapability(Capabilities.ItemHandler.BLOCK, lookup.tile.getBlockPos(), (Object)Direction.values()[lookup.otherDirection]);
        if (itemCap != null) {
            return itemCap.getSlots() > 0;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onLinksRemoved(List<ClientSideLinkCache.ClientLink> removed) {
        for (ClientSideLinkCache.ClientLink link : removed) {
            LinkedList<Vector3> points = link.getPointListFor(this.pos());
            PneumaticSmokeParticle p = new PneumaticSmokeParticle((ClientLevel)this.level(), points);
            p.setAlpha(0.0f);
            p.addAction(ParticleAction.sequence((ParticleAction[])new ParticleAction[]{ParticleAction.changeAlphaTo((double)0.7, (double)1.0), ParticleAction.changeAlphaTo((double)0.0, (double)5.0), ParticleAction.remove()}));
            Minecraft.getInstance().particleEngine.add((Particle)p);
            ((ClientLevel)this.level()).playLocalSound(this.pos(), ExpansionSounds.DEPRESSURIZE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onLinksAdded(List<ClientSideLinkCache.ClientLink> added) {
        for (ClientSideLinkCache.ClientLink link : added) {
            LinkedList<Vector3> points = link.getPointListFor(this.pos());
            PneumaticSmokeParticle p = new PneumaticSmokeParticle((ClientLevel)this.level(), points);
            p.setAlpha(0.0f);
            p.addAction(ParticleAction.sequence((ParticleAction[])new ParticleAction[]{ParticleAction.changeAlphaTo((double)0.7, (double)1.0), ParticleAction.changeAlphaTo((double)0.0, (double)10.0), ParticleAction.remove()}));
            Minecraft.getInstance().particleEngine.add((Particle)p);
            ((ClientLevel)this.level()).playLocalSound(this.pos(), ExpansionSounds.PRESSURIZE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
    }

    @Override
    public void onNodeChanged(boolean linksChanged, boolean stateChange) {
        if (!this.level().isClientSide) {
            if (linksChanged) {
                this.linkCache.setLinks(this.node.getLinks());
                this.linkCache.setActive(this.node.isActive());
                this.sendNodeLinkUpdate();
            } else if (stateChange) {
                this.linkCache.setActive(this.node.isActive());
                this.sendNodeStateUpdate();
            }
        }
    }

    @Override
    public boolean requiresActiveNode() {
        int connectedTubes = 0;
        for (int s = 0; s < 6; ++s) {
            if (!this.maskConnects(s)) continue;
            if (++connectedTubes > 2) {
                return true;
            }
            if (!this.hasEndpointOnSide(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setOutputDirection(PneumaticTubePayload payload) {
        if (this.level().isClientSide) {
            return;
        }
        int connMask = this.getConnMap() & 0x3F;
        int connCount = Integer.bitCount(this.getConnMap() & 0x3F);
        if (connCount == 0) {
            return;
        }
        if (connCount == 1) {
            payload.setOutputSide(Integer.numberOfTrailingZeros(connMask));
            return;
        }
        int exitMask = connMask & ~(1 << payload.getInputSide());
        int exitCount = Integer.bitCount(exitMask);
        assert (exitCount > 0);
        if (exitCount == 1) {
            int s = Integer.numberOfTrailingZeros(exitMask);
            payload.setOutputSide(s);
            return;
        }
        PneumaticExitPathfinder exitFinder = new PneumaticExitPathfinder(this, this.getNode().getRouteTable(), payload, exitMask);
        PneumaticExitPathfinder.PneumaticExits result = exitFinder.result();
        int routeMask = result.exitDirMask();
        int routeCount = Integer.bitCount(routeMask);
        if (routeCount == 0) {
            this.setOutputRoundRobin(payload, exitMask);
            return;
        }
        if (routeCount == 1) {
            int s = Integer.numberOfTrailingZeros(routeMask);
            payload.setOutputSide(s);
            return;
        }
        this.setOutputRoundRobin(payload, routeMask);
    }

    private void setOutputRoundRobin(PneumaticTubePayload payload, int dirMask) {
        assert ((dirMask & 0x3F) != 0);
        int s = this.lastRoundRobinDir;
        while ((dirMask & 1 << (s = (s + 1) % 6)) == 0) {
        }
        this.lastRoundRobinDir = s;
        payload.setOutputSide(s);
    }

    @Override
    public void onPayloadChanged(int id, PneumaticTubePayload payload) {
        if (!this.level().isClientSide) {
            this.sendPayloadUpdate(id, payload);
        }
    }

    @Override
    public boolean onPayloadReachedOutput(int id, PneumaticTubePayload payload) {
        WorldlyContainer wc;
        PneumaticTransportDevice p;
        if (this.level().isClientSide) {
            return false;
        }
        CenterLookup lookup = CenterLookup.lookupStraightCenter((Level)this.level(), (BlockPos)this.pos(), (int)payload.getOutputSide());
        MultiPart multiPart = lookup.part;
        if (multiPart instanceof PneumaticTransportContainer) {
            PneumaticTransportContainer ptc = (PneumaticTransportContainer)multiPart;
            int side = payload.getOutputSide();
            payload.setInputSide(payload.getOutputSide() ^ 1);
            payload.resetOutput();
            payload.resetProgress();
            int newId = ptc.getPneumaticTransport().addPayload(payload);
            this.sendPayloadHandoff(id, payload, newId, side);
            return true;
        }
        if (lookup.tile == null) {
            return false;
        }
        BlockEntity side = lookup.tile;
        if (side instanceof PneumaticTransportDevice && (p = (PneumaticTransportDevice)side).insertPayload(lookup.otherDirection, payload)) {
            this.sendPayloadRemoved(Collections.singletonList(id));
            return true;
        }
        side = lookup.tile;
        if (side instanceof WorldlyContainer && InventoryLib.injectWorldly((WorldlyContainer)(wc = (WorldlyContainer)side), (ItemStack)payload.getItemStack(), (int)lookup.otherDirection, (boolean)false)) {
            this.sendPayloadRemoved(Collections.singletonList(id));
            return true;
        }
        IItemHandler itemCap = (IItemHandler)this.level().getCapability(Capabilities.ItemHandler.BLOCK, lookup.tile.getBlockPos(), (Object)Direction.values()[lookup.otherDirection]);
        if (itemCap != null && InventoryLib.injectItemHandler((IItemHandler)itemCap, (ItemStack)payload.getItemStack(), (boolean)false)) {
            this.sendPayloadRemoved(Collections.singletonList(id));
            return true;
        }
        int tmp = payload.getInputSide();
        payload.setInputSide(payload.getOutputSide());
        payload.setOutputSide(tmp);
        payload.resetProgress();
        this.sendPayloadUpdate(id, payload);
        return false;
    }

    @Override
    public boolean canItemExitTube(PneumaticTubePayload payload, int side, PneumaticTransportMode mode) {
        IItemHandler itemCap;
        ItemStack copy;
        if (!this.maskConnects(side)) {
            return false;
        }
        CenterLookup lookup = CenterLookup.lookupStraightCenter((Level)this.level(), (BlockPos)this.pos(), (int)side);
        if (lookup.tile == null) {
            return false;
        }
        BlockEntity blockEntity = lookup.tile;
        if (blockEntity instanceof PneumaticTransportDevice) {
            PneumaticTransportDevice p = (PneumaticTransportDevice)blockEntity;
            return p.canAcceptPayload(lookup.otherDirection, payload, mode);
        }
        blockEntity = lookup.tile;
        if (blockEntity instanceof WorldlyContainer) {
            WorldlyContainer wc = (WorldlyContainer)blockEntity;
            copy = payload.getItemStack().copy();
            InventoryLib.injectWorldly((WorldlyContainer)wc, (ItemStack)copy, (int)lookup.otherDirection, (boolean)true);
            if (copy.getCount() < payload.getItemStack().getCount()) {
                return true;
            }
        }
        if ((itemCap = (IItemHandler)this.level().getCapability(Capabilities.ItemHandler.BLOCK, lookup.tile.getBlockPos(), (Object)Direction.values()[lookup.otherDirection])) != null) {
            copy = payload.getItemStack().copy();
            InventoryLib.injectItemHandler((IItemHandler)itemCap, (ItemStack)copy, (boolean)true);
            if (copy.getCount() < payload.getItemStack().getCount()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canItemEnterTube(PneumaticTubePayload payload, int side) {
        if (!this.maskConnects(side)) {
            return false;
        }
        PneumaticExitPathfinder exitFinder = new PneumaticExitPathfinder(this, this.getNode().getRouteTable(), payload, ~(1 << side), List.of(PneumaticTransportMode.PASSIVE_NORMAL));
        return exitFinder.result().exitDirMask() != 0;
    }

    @Override
    public boolean insertPayload(int s, PneumaticTubePayload payload) {
        if (!this.canItemEnterTube(payload, s)) {
            return false;
        }
        payload.resetProgress();
        payload.resetOutput();
        payload.setSpeed(12);
        payload.setInputSide(s);
        int id = this.transport.addPayload(payload);
        this.sendNewPayload(id, Objects.requireNonNull(this.transport.getPayload(id)));
        return true;
    }
}

