/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.multipart.api.RedstoneInteractions;
import codechicken.multipart.api.tile.RedstoneConnector;
import java.util.Set;
import javax.annotation.Nullable;
import mrtjp.projectred.api.Frame;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.api.MovementDescriptor;
import mrtjp.projectred.api.ProjectRedAPI;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.core.tile.IOrientableBlockEntity;
import mrtjp.projectred.expansion.MovementManager;
import mrtjp.projectred.expansion.tile.LowLoadPoweredBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class BaseFrameMoverBlockEntity
extends LowLoadPoweredBlockEntity
implements RedstoneConnector,
IOrientableBlockEntity,
Frame {
    protected boolean powered = false;
    protected boolean isCharged = false;
    protected boolean isWorking = false;
    @Nullable
    private MovementDescriptor descriptor = null;

    public BaseFrameMoverBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void saveToNBT(CompoundTag tag) {
        super.saveToNBT(tag);
        tag.putBoolean("powered", this.powered);
    }

    @Override
    public void loadFromNBT(CompoundTag tag) {
        super.loadFromNBT(tag);
        this.powered = tag.getBoolean("powered");
    }

    protected boolean isMoving() {
        return this.descriptor != null && this.descriptor.isMoving() && this.descriptor.getProgress() < 1.0;
    }

    protected void drawPower(int structureSize) {
        if (this.canConductorWork()) {
            this.conductor.applyPower((double)(-(100 + structureSize * 10)));
        }
    }

    protected void beginMove() {
        assert (this.level != null);
        BlockPos blockInFront = this.getBlockPos().relative(Direction.values()[this.getFrontSide()]);
        if (this.level.isEmptyBlock(blockInFront)) {
            return;
        }
        if (MovementManager.getInstance(this.level).getMovementInfo(blockInFront).isMoving()) {
            return;
        }
        if (MovementManager.getInstance(this.level).getMovementInfo(this.getBlockPos()).isMoving()) {
            return;
        }
        assert (ProjectRedAPI.expansionAPI != null);
        Set blocks = ProjectRedAPI.expansionAPI.getStructure(this.level, blockInFront, new BlockPos[]{this.getBlockPos()});
        MovementDescriptor desc = ProjectRedAPI.expansionAPI.beginMove(this.level, this.getMoveDir(), 0.0625, blocks);
        if (desc.getStatus() == MovementDescriptor.MovementStatus.MOVING) {
            this.descriptor = desc;
        }
    }

    @Override
    public void tick() {
        BlockState state;
        super.tick();
        assert (this.level != null);
        if (this.level.isClientSide) {
            return;
        }
        this.isCharged = this.canConductorWork();
        this.isWorking = this.isMoving();
        if (this.isWorking) {
            assert (this.descriptor != null);
            this.drawPower(this.descriptor.getSize());
        }
        if (this.isCharged != (Boolean)(state = this.getBlockState()).getValue((Property)ProjectRedBlock.CHARGED) || this.isWorking != (Boolean)state.getValue((Property)ProjectRedBlock.WORKING)) {
            this.pushBlockState();
        }
    }

    public void onNeighborBlockChanged(BlockPos neighborPos) {
        super.onNeighborBlockChanged(neighborPos);
        assert (this.level != null);
        if (this.level.isClientSide) {
            return;
        }
        boolean oldPowered = this.powered;
        for (int s = 0; s < 6; ++s) {
            boolean bl = this.powered = RedstoneInteractions.getPowerTo((Level)this.level, (BlockPos)this.getBlockPos(), (int)s, (int)31) > 0;
            if (this.powered) break;
        }
        if (!oldPowered && this.powered && !this.isWorking && this.canConductorWork()) {
            this.beginMove();
        }
    }

    public void onOrientationChange() {
        if (!this.getLevel().isClientSide) {
            this.updateExternals();
            this.notifyExternals(15);
        }
    }

    @Override
    public boolean canConnectPart(IConnectable part, int s, int edgeRot) {
        return s != this.getFrontSide() && super.canConnectPart(part, s, edgeRot);
    }

    public BlockState storeBlockState(BlockState defaultState) {
        return (BlockState)((BlockState)super.storeBlockState(defaultState).setValue((Property)ProjectRedBlock.CHARGED, (Comparable)Boolean.valueOf(this.isCharged))).setValue((Property)ProjectRedBlock.WORKING, (Comparable)Boolean.valueOf(this.isWorking));
    }

    public int getConnectionMask(int side) {
        return side == this.getFrontSide() ? 0 : 31;
    }

    public int weakPowerLevel(int side, int mask) {
        return 0;
    }

    public boolean canGrab(Level w, BlockPos pos, Direction side) {
        return side.ordinal() == this.getFrontSide();
    }

    public boolean canBeGrabbed(Level w, BlockPos pos, Direction side) {
        return side.ordinal() != this.getFrontSide();
    }

    protected abstract int getFrontSide();

    protected abstract int getMoveDir();
}

