/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.lib.util.ServerUtils;
import codechicken.lib.vec.Vector3;
import com.mojang.authlib.GameProfile;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import mrtjp.projectred.core.inventory.BaseContainer;
import mrtjp.projectred.expansion.ProjectRedExpansion;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.inventory.container.DeployerMenu;
import mrtjp.projectred.expansion.tile.BaseDeviceBlockEntity;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class DeployerBlockEntity
extends BaseDeviceBlockEntity {
    private static final GameProfile PR_FAKE_PLAYER = new GameProfile(UUID.fromString("6140461b-e5b4-41ba-beb1-dce616e6abc0"), "[ProjectRed]");
    private final BaseContainer inventory = new BaseContainer(9);
    private final IItemHandler handler = new InvWrapper((Container)this.inventory);

    public DeployerBlockEntity(BlockPos pos, BlockState state) {
        super(ExpansionBlocks.DEPLOYER_BLOCK_ENTITY.get(), pos, state);
        this.inventory.addListener(c -> this.setChanged());
    }

    @Override
    public void saveToNBT(CompoundTag tag) {
        super.saveToNBT(tag);
        this.inventory.saveTo(tag, "inventory");
    }

    @Override
    public void loadFromNBT(CompoundTag tag) {
        super.loadFromNBT(tag);
        this.inventory.loadFrom(tag, "inventory");
    }

    public void onBlockRemoved() {
        super.onBlockRemoved();
        DeployerBlockEntity.dropInventory((Container)this.inventory, (Level)this.getLevel(), (Vector3)Vector3.fromBlockPos((BlockPos)this.getBlockPos()));
    }

    @Override
    public InteractionResult onBlockActivated(Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.getLevel().isClientSide) {
            ServerUtils.openContainer((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new DeployerMenu(inv, this, id), (Component)this.getBlockState().getBlock().getName()), p -> p.writePos(this.getBlockPos()));
        }
        return InteractionResult.sidedSuccess((boolean)this.getLevel().isClientSide);
    }

    @Override
    protected void onActivated() {
        FakePlayer player = FakePlayerFactory.get((ServerLevel)((ServerLevel)this.getLevel()), (GameProfile)PR_FAKE_PLAYER);
        player.getInventory().clearContent();
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            player.getInventory().setItem(i, this.inventory.getItem(i));
        }
        boolean success = this.deployFromFakePlayer((Player)player);
        if (success) {
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                this.inventory.setItem(i, player.getInventory().getItem(i));
            }
            LinkedList<ItemStack> remaining = new LinkedList<ItemStack>();
            for (int i = this.inventory.getContainerSize(); i < player.getInventory().getContainerSize(); ++i) {
                ItemStack rem = this.inventory.addItem(player.getInventory().getItem(i));
                if (rem.isEmpty()) continue;
                remaining.add(rem);
            }
            if (!remaining.isEmpty()) {
                this.handlePostDeployExcess(remaining);
            }
        }
    }

    @Override
    protected void onDeactivated() {
    }

    protected boolean deployFromFakePlayer(Player player) {
        Direction useDir = Direction.values()[this.side ^ 1];
        BlockPos usePos = this.getBlockPos().relative(useDir);
        Vec3 hitTarget = new Vec3((double)usePos.getX() + 0.5, (double)usePos.getY() + 0.5, (double)usePos.getZ() + 0.5);
        BlockHitResult hit = new BlockHitResult(hitTarget, Direction.values()[this.side], usePos, false);
        player.setPos((double)this.getBlockPos().getX() + 0.5 + (double)useDir.getStepX() * 0.9, (double)this.getBlockPos().getY() + 0.5 + (double)useDir.getStepY() * 0.9 - (double)player.getEyeHeight(), (double)this.getBlockPos().getZ() + 0.5 + (double)useDir.getStepZ() * 0.9);
        player.lookAt(EntityAnchorArgument.Anchor.EYES, hitTarget);
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty()) continue;
            ItemStack mainHand = player.getMainHandItem();
            player.setItemSlot(EquipmentSlot.MAINHAND, stack);
            player.getInventory().setItem(i, mainHand);
            InteractionResult result = this.runInteractWithEntityLogic(player, usePos, hit);
            if (!result.consumesAction()) {
                result = this.runUseOnLogic(player, usePos, hit);
            }
            ItemStack slotStack = player.getInventory().getItem(i);
            player.getInventory().setItem(i, player.getMainHandItem());
            player.setItemSlot(EquipmentSlot.MAINHAND, slotStack);
            if (!result.consumesAction()) continue;
            return true;
        }
        return false;
    }

    protected InteractionResult runUseOnLogic(Player player, BlockPos usePos, BlockHitResult hit) {
        InteractionResult result;
        PlayerInteractEvent.RightClickBlock event = CommonHooks.onRightClickBlock((Player)player, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)usePos, (BlockHitResult)hit);
        if (event.isCanceled()) {
            return event.getCancellationResult();
        }
        UseOnContext ctx = new UseOnContext(player, InteractionHand.MAIN_HAND, hit);
        if (event.getUseItem() != Event.Result.DENY && (result = player.getMainHandItem().onItemUseFirst(ctx)).consumesAction()) {
            return result;
        }
        if (event.getUseBlock() != Event.Result.DENY && (result = this.getLevel().getBlockState(usePos).use(this.getLevel(), player, InteractionHand.MAIN_HAND, hit)).consumesAction()) {
            return result;
        }
        if (event.getUseItem() == Event.Result.DENY) {
            return InteractionResult.PASS;
        }
        result = player.getMainHandItem().useOn(ctx);
        if (result.consumesAction()) {
            return result;
        }
        result = CommonHooks.onItemRightClick((Player)player, (InteractionHand)InteractionHand.MAIN_HAND);
        if (result != null) {
            return result;
        }
        player.useItem = ItemStack.EMPTY;
        player.useItemRemaining = 0;
        InteractionResultHolder resultHolder = player.getMainHandItem().use(this.getLevel(), player, InteractionHand.MAIN_HAND);
        if (resultHolder.getResult().consumesAction()) {
            player.setItemInHand(InteractionHand.MAIN_HAND, (ItemStack)resultHolder.getObject());
            if (!player.useItem.isEmpty()) {
                player.useItemRemaining = 0;
                player.releaseUsingItem();
            }
            return resultHolder.getResult();
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult runInteractWithEntityLogic(Player player, BlockPos usePos, BlockHitResult hit) {
        List entities = this.getLevel().getEntities((Entity)player, new AABB(usePos));
        for (Entity entity : entities) {
            InteractionResult result = player.interactOn(entity, InteractionHand.MAIN_HAND);
            if (result.consumesAction()) {
                return result;
            }
            Vec3 vec3 = hit.getLocation().subtract(entity.getX(), entity.getY(), entity.getZ());
            result = CommonHooks.onInteractEntityAt((Player)player, (Entity)entity, (Vec3)vec3, (InteractionHand)InteractionHand.MAIN_HAND);
            if (result != null) {
                return result;
            }
            result = entity.interactAt(player, vec3, InteractionHand.MAIN_HAND);
            if (!result.consumesAction()) continue;
            return result;
        }
        return InteractionResult.PASS;
    }

    protected void handlePostDeployExcess(List<ItemStack> excess) {
        ProjectRedExpansion.LOGGER.warn("Deployer at {} has excess items: {}", (Object)this.getBlockPos(), excess);
    }

    public IItemHandler getHandler() {
        return this.handler;
    }

    public BaseContainer getInventory() {
        return this.inventory;
    }
}

