/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.util.ServerUtils;
import codechicken.lib.vec.Vector3;
import mrtjp.projectred.core.inventory.BaseContainer;
import mrtjp.projectred.core.tile.IPacketReceiverBlockEntity;
import mrtjp.projectred.core.tile.ProjectRedBlockEntity;
import mrtjp.projectred.expansion.CraftingHelper;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.inventory.container.ProjectBenchMenu;
import mrtjp.projectred.expansion.item.RecipePlanItem;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class ProjectBenchBlockEntity
extends ProjectRedBlockEntity
implements IPacketReceiverBlockEntity,
CraftingHelper.InventorySource {
    private static final int KEY_WRITE_PLAN = 2;
    private static final int KEY_CLEAR_GRID = 3;
    private final BaseContainer planInventory = new BaseContainer(1){

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return stack.getItem() instanceof RecipePlanItem;
        }
    };
    private final BaseContainer craftingGrid = new BaseContainer(9);
    private final BaseContainer storageInventory = new BaseContainer(18);
    private final BaseContainer planCraftingGrid = new BaseContainer(9);
    private final CraftingHelper craftingHelper = new CraftingHelper(this);
    private final IItemHandler handler = new InvWrapper((Container)this.storageInventory);
    private boolean isPlanRecipe = false;
    private boolean recipeNeedsUpdate = true;

    public ProjectBenchBlockEntity(BlockPos pos, BlockState state) {
        super(ExpansionBlocks.PROJECT_BENCH_BLOCK_ENTITY.get(), pos, state);
        this.planInventory.addListener(this::onInventoryChanged);
        this.craftingGrid.addListener(this::onInventoryChanged);
        this.storageInventory.addListener(this::onInventoryChanged);
    }

    public void saveToNBT(CompoundTag tag) {
        this.planInventory.saveTo(tag, "plan_inv");
        this.craftingGrid.saveTo(tag, "crafting_inv");
        this.storageInventory.saveTo(tag, "storage_inv");
        this.planCraftingGrid.saveTo(tag, "plan_crafting_inv");
    }

    public void loadFromNBT(CompoundTag tag) {
        this.planInventory.loadFrom(tag, "plan_inv");
        this.craftingGrid.loadFrom(tag, "crafting_inv");
        this.storageInventory.loadFrom(tag, "storage_inv");
        this.planCraftingGrid.loadFrom(tag, "plan_crafting_inv");
    }

    public void writeDesc(MCDataOutput out) {
    }

    public void readDesc(MCDataInput in) {
    }

    public void receiveUpdateFromServer(int key, MCDataInput input) {
    }

    public void receiveUpdateFromClient(int key, MCDataInput input, ServerPlayer player) {
        switch (key) {
            case 2: {
                this.writePlan();
                break;
            }
            case 3: {
                this.clearGrid(player);
                break;
            }
        }
    }

    public void sendWriteButtonPressed() {
        this.sendUpdateToServer(2, out -> {});
    }

    public void sendGridClearButtonPressed() {
        this.sendUpdateToServer(3, out -> {});
    }

    public InteractionResult onBlockActivated(Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.getLevel().isClientSide) {
            ServerUtils.openContainer((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new ProjectBenchMenu(inv, this, id), (Component)this.getBlockState().getBlock().getName()), p -> p.writePos(this.getBlockPos()));
        }
        return InteractionResult.sidedSuccess((boolean)this.getLevel().isClientSide);
    }

    public void onBlockRemoved() {
        Vector3 pos = Vector3.fromTileCenter((BlockEntity)this);
        ProjectBenchBlockEntity.dropInventory((Container)this.craftingGrid, (Level)this.getLevel(), (Vector3)pos);
        ProjectBenchBlockEntity.dropInventory((Container)this.planInventory, (Level)this.getLevel(), (Vector3)pos);
        ProjectBenchBlockEntity.dropInventory((Container)this.storageInventory, (Level)this.getLevel(), (Vector3)pos);
    }

    public void tick() {
        this.updateRecipeIfNeeded();
        if (!this.getLevel().isClientSide) {
            this.transferExcessToStorage();
        }
    }

    public void updateRecipeIfNeeded() {
        if (this.recipeNeedsUpdate) {
            ItemStack plan;
            this.recipeNeedsUpdate = false;
            this.isPlanRecipe = false;
            boolean gridEmpty = true;
            for (int i = 0; i < 9; ++i) {
                if (this.craftingGrid.getItem(i).isEmpty()) continue;
                gridEmpty = false;
                break;
            }
            if (gridEmpty && RecipePlanItem.hasRecipeInside(plan = this.planInventory.getItem(0))) {
                this.isPlanRecipe = true;
                RecipePlanItem.loadPlanInputsToGrid((Container)this.planCraftingGrid, plan);
            }
            this.craftingHelper.onInventoryChanged();
        }
    }

    private void onInventoryChanged(Container inventory) {
        this.recipeNeedsUpdate = true;
        this.setChanged();
    }

    private void transferExcessToStorage() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.craftingGrid.getItem(i);
            if (stack.isEmpty() || stack.getCount() <= 1) continue;
            int toMove = Math.max(1, stack.getCount() / 4);
            ItemStack removed = this.craftingGrid.removeItem(i, toMove);
            InventoryLib.injectItemStack((Container)this.storageInventory, (ItemStack)removed, (boolean)false);
            if (removed.isEmpty()) continue;
            this.craftingGrid.getItem(i).grow(removed.getCount());
            this.craftingGrid.setChanged();
        }
    }

    private void writePlan() {
        this.updateRecipeIfNeeded();
        if (this.craftingHelper.hasRecipe() && !this.isPlanRecipe) {
            ItemStack planStack = this.planInventory.getItem(0);
            ItemStack result = this.craftingHelper.getRecipeOutout();
            if (!planStack.isEmpty() && !result.isEmpty()) {
                ItemStack[] inputs = new ItemStack[9];
                for (int i = 0; i < 9; ++i) {
                    inputs[i] = this.craftingGrid.getItem(i).copy();
                }
                RecipePlanItem.savePlan(planStack, inputs, result);
            }
        }
    }

    private void clearGrid(ServerPlayer player) {
        AbstractContainerMenu container = player.containerMenu;
        if (container instanceof ProjectBenchMenu) {
            ((ProjectBenchMenu)container).transferAllFromGrid();
            this.updateRecipeIfNeeded();
        }
    }

    @Override
    public Container getCraftingMatrix() {
        return this.isPlanRecipe ? this.planCraftingGrid : this.craftingGrid;
    }

    @Override
    public Container getStorage() {
        return this.storageInventory;
    }

    @Override
    public boolean canConsumeFromCraftingMatrix() {
        return !this.isPlanRecipe;
    }

    @Override
    public Level getWorld() {
        return this.getLevel();
    }

    public SimpleContainer getPlanInventory() {
        return this.planInventory;
    }

    public SimpleContainer getCraftingGridInventory() {
        return this.craftingGrid;
    }

    public SimpleContainer getStorageInventory() {
        return this.storageInventory;
    }

    public boolean isPlanRecipe() {
        return this.isPlanRecipe;
    }

    public CraftingHelper getCraftingHelper() {
        return this.craftingHelper;
    }

    public IItemHandler getHandler() {
        return this.handler;
    }
}

