/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.inventory.container;

import codechicken.lib.inventory.container.ICCLContainerFactory;
import mrtjp.projectred.exploration.init.ExplorationMenus;
import mrtjp.projectred.exploration.inventory.BackpackInventory;
import mrtjp.projectred.exploration.item.BackpackItem;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BackpackMenu
extends AbstractContainerMenu {
    public static final ICCLContainerFactory<BackpackMenu> FACTORY = (windowId, playerInv, packet) -> new BackpackMenu(windowId, playerInv);
    private final BackpackInventory inventory = new BackpackInventory(27);
    private final Inventory playerInventory;

    public BackpackMenu(int windowId, Inventory playerInventory) {
        super(ExplorationMenus.BACKPACK_MENU.get(), windowId);
        this.playerInventory = playerInventory;
        InventoryLib.addPlayerInventory((Inventory)playerInventory, (int)8, (int)86, BackpackPlayerSlot::new, x$0 -> this.addSlot((Slot)x$0));
        InventoryLib.addInventory((Container)this.inventory, (int)0, (int)8, (int)18, (int)9, (int)3, BackpackSlot::new, x$0 -> this.addSlot((Slot)x$0));
        this.inventory.addListener(this::onBackpackInventoryChanged);
        this.inventory.loadInventoryFromMainHand(playerInventory);
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        int hotbarIndex;
        if (this.isHotbar(slotId) && (hotbarIndex = slotId - 27) == player.getInventory().selected) {
            return;
        }
        if (clickType == ClickType.SWAP && dragType == player.getInventory().selected) {
            return;
        }
        super.clicked(slotId, dragType, clickType, player);
    }

    public void removed(Player player) {
        super.removed(player);
        this.inventory.saveInventoryToMainHand(this.playerInventory);
    }

    public boolean stillValid(Player player) {
        ItemStack stack = player.getMainHandItem();
        return BackpackItem.isBackpack(stack);
    }

    protected void onBackpackInventoryChanged(Container backpackInventory) {
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack originalStack = stack.copy();
        if (this.isBag(slotIndex) ? !this.moveToEntireInventory(stack, true) : !this.moveToBag(stack, false)) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stack.getCount() == originalStack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stack);
        return originalStack;
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isBag(int slotIndex) {
        return slotIndex >= 36 && slotIndex < 63;
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 27, reverse);
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 27, 36, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 36, reverse);
    }

    private boolean moveToBag(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 36, 63, reverse);
    }

    private static class BackpackSlot
    extends Slot {
        public BackpackSlot(Container inventory, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return BackpackItem.isItemAllowedInBackpack(stack);
        }
    }

    private static class BackpackPlayerSlot
    extends Slot {
        public BackpackPlayerSlot(Container inventory, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
        }

        public boolean mayPickup(Player player) {
            return this.getSlotIndex() != player.getInventory().selected;
        }
    }
}

