/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.item.crafting;

import java.util.Objects;
import mrtjp.projectred.exploration.init.ExplorationItems;
import mrtjp.projectred.exploration.init.ExplorationRecipeSerializers;
import mrtjp.projectred.exploration.item.BackpackItem;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;

public class BackpackDyeRecipe
extends CustomRecipe {
    public BackpackDyeRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingContainer inventory, Level world) {
        ItemStack backpack = ItemStack.EMPTY;
        ItemStack dye = ItemStack.EMPTY;
        int itemCount = 0;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty()) continue;
            ++itemCount;
            if (stack.getItem() instanceof BackpackItem) {
                if (!backpack.isEmpty()) {
                    return false;
                }
                backpack = stack;
                continue;
            }
            if (!stack.is(Tags.Items.DYES)) continue;
            if (!dye.isEmpty()) {
                return false;
            }
            dye = stack;
        }
        if (itemCount != 2 || backpack.isEmpty() || dye.isEmpty()) {
            return false;
        }
        DyeColor backpackColor = ((BackpackItem)backpack.getItem()).getDyeColor();
        DyeColor dyeColor = DyeColor.getColor((ItemStack)dye);
        if (dyeColor == null) {
            return false;
        }
        return backpackColor != dyeColor;
    }

    public ItemStack assemble(CraftingContainer inventory, RegistryAccess registryAccess) {
        ItemStack backpack = ItemStack.EMPTY;
        ItemStack dye = ItemStack.EMPTY;
        int itemCount = 0;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty()) continue;
            ++itemCount;
            if (stack.getItem() instanceof BackpackItem) {
                if (!backpack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                backpack = stack;
                continue;
            }
            if (!stack.is(Tags.Items.DYES)) continue;
            if (!dye.isEmpty()) {
                return ItemStack.EMPTY;
            }
            dye = stack;
        }
        if (itemCount != 2 || backpack.isEmpty() || dye.isEmpty()) {
            return ItemStack.EMPTY;
        }
        DyeColor backpackColor = ((BackpackItem)backpack.getItem()).getDyeColor();
        DyeColor dyeColor = DyeColor.getColor((ItemStack)dye);
        if (dyeColor == null || backpackColor == dyeColor) {
            return ItemStack.EMPTY;
        }
        ItemStack result = new ItemStack((ItemLike)ExplorationItems.getBackpackByColor(dyeColor.getId()));
        if (backpack.hasTag()) {
            result.setTag(Objects.requireNonNull(backpack.getTag()).copy());
        }
        return result;
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x * y >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ExplorationRecipeSerializers.BACKPACK_DYE_RECIPE_SERIALIZER.get();
    }
}

