/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.world.gen;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import mrtjp.projectred.exploration.init.ExplorationBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CaveWorldCarver;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class MarbleCaveWorldCarver
extends CaveWorldCarver {
    public MarbleCaveWorldCarver(Codec<CaveCarverConfiguration> codec) {
        super(codec);
    }

    protected boolean canReplaceBlock(CaveCarverConfiguration pConfig, BlockState pState) {
        return !pState.isAir() && (super.canReplaceBlock((CarverConfiguration)pConfig, pState) || pState.is(ExplorationBlocks.MARBLE_BLOCK.get()));
    }

    protected boolean carveBlock(CarvingContext context, CaveCarverConfiguration config, ChunkAccess chunkAccess, Function<BlockPos, Holder<Biome>> biomeGetter, CarvingMask mask, BlockPos.MutableBlockPos pos1, BlockPos.MutableBlockPos pos2, Aquifer aquifer, MutableBoolean markFluidUpdate) {
        if (!super.carveBlock(context, (CarverConfiguration)config, chunkAccess, biomeGetter, mask, pos1, pos2, aquifer, markFluidUpdate)) {
            return false;
        }
        BlockPos.MutableBlockPos pos = pos1.mutable();
        BlockState carvedState = chunkAccess.getBlockState((BlockPos)pos);
        if (carvedState.is(Blocks.AIR) || carvedState.is(Blocks.CAVE_AIR)) {
            BlockState marbleState = ExplorationBlocks.MARBLE_BLOCK.get().defaultBlockState();
            for (int s = 0; s < 6; ++s) {
                pos.set((Vec3i)pos1).move(Direction.values()[s]);
                BlockState adjacentState = chunkAccess.getBlockState((BlockPos)pos);
                if (!this.canReplaceBlock(config, adjacentState)) continue;
                chunkAccess.setBlockState((BlockPos)pos, marbleState, false);
            }
        }
        return true;
    }
}

