/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion;

import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.init.CBMultipartModContent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mrtjp.projectred.api.BlockMover;
import mrtjp.projectred.api.Frame;
import mrtjp.projectred.api.FrameInteraction;
import mrtjp.projectred.api.IExpansionAPI;
import mrtjp.projectred.api.MovementController;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;

public class MovementRegistry {
    private static final List<FrameInteraction> frameInteractions = new LinkedList<FrameInteraction>();
    private static final Map<Block, BlockMover> blockMovers = new HashMap<Block, BlockMover>();

    public static void init() {
        blockMovers.put((Block)CBMultipartModContent.MULTIPART_BLOCK.get(), MultipartTileMover.INSTANCE);
    }

    public static void registerBlockMover(Block block, BlockMover mover) {
        blockMovers.put(block, mover);
    }

    public static void registerFrameInteraction(FrameInteraction interaction) {
        frameInteractions.add(interaction);
    }

    @Nullable
    public static Frame getFrame(Level level, BlockPos pos) {
        Frame cap;
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof Frame) {
            Frame f = (Frame)block;
            return f;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof Frame) {
            Frame f = (Frame)be;
            return f;
        }
        if (be != null && (cap = (Frame)level.getCapability(IExpansionAPI.FRAME_CAPABILITY, pos, state, be, null)) != null) {
            return cap;
        }
        for (FrameInteraction interaction : frameInteractions) {
            if (!interaction.canInteract(level, pos)) continue;
            return interaction;
        }
        return null;
    }

    @Nullable
    public static MovementController getMovementController(Level level, BlockPos pos) {
        MovementController cap;
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof MovementController) {
            MovementController mhb = (MovementController)block;
            return mhb;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof MovementController) {
            MovementController mbe = (MovementController)be;
            return mbe;
        }
        if (be != null && (cap = (MovementController)level.getCapability(IExpansionAPI.MOVEMENT_CONTROLLER_CAPABILITY, pos, state, be, null)) != null) {
            return cap;
        }
        return null;
    }

    public static BlockMover getMover(Level level, BlockPos pos) {
        Block block = level.getBlockState(pos).getBlock();
        if (blockMovers.containsKey(block)) {
            return blockMovers.get(block);
        }
        return SaveLoadTileMover.INSTANCE;
    }

    private static void silentSetBlockState(LevelChunk chunk, BlockPos pos, BlockState state) {
        int l;
        int k;
        int y = pos.getY();
        LevelChunkSection section = chunk.getSection(chunk.getSectionIndex(y));
        boolean hasOnlyAir = section.hasOnlyAir();
        if (hasOnlyAir && state.isAir()) {
            return;
        }
        int j = pos.getX() & 0xF;
        BlockState oldState = section.setBlockState(j, k = y & 0xF, l = pos.getZ() & 0xF, state);
        if (oldState == state) {
            return;
        }
        chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.MOTION_BLOCKING).update(j, y, l, state);
        chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES).update(j, y, l, state);
        chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.OCEAN_FLOOR).update(j, y, l, state);
        chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE).update(j, y, l, state);
    }

    private static class MultipartTileMover
    implements BlockMover {
        public static final MultipartTileMover INSTANCE = new MultipartTileMover();

        private MultipartTileMover() {
        }

        public boolean canMove(Level w, BlockPos pos) {
            return w.getBlockEntity(pos) instanceof TileMultipart;
        }

        public void move(Level w, BlockPos pos, Direction dir) {
            BlockEntity be = w.getBlockEntity(pos);
            if (!(be instanceof TileMultipart)) {
                return;
            }
            TileMultipart tmp = (TileMultipart)be;
            LevelChunk chunk = w.getChunkAt(pos);
            BlockState state = w.getBlockState(pos);
            BlockPos pos2 = pos.relative(dir);
            LevelChunk chunk2 = w.getChunkAt(pos2);
            MovementRegistry.silentSetBlockState(chunk, pos, Blocks.AIR.defaultBlockState());
            chunk.removeBlockEntity(pos);
            MovementRegistry.silentSetBlockState(chunk2, pos2, state);
            tmp.worldPosition = pos2;
            chunk2.addAndRegisterBlockEntity((BlockEntity)tmp);
        }

        public void postMove(Level w, BlockPos pos) {
            BlockEntity be = w.getBlockEntity(pos);
            if (be instanceof TileMultipart) {
                TileMultipart tmp = (TileMultipart)be;
                tmp.onMoved();
            }
        }
    }

    private static class SaveLoadTileMover
    implements BlockMover {
        public static final SaveLoadTileMover INSTANCE = new SaveLoadTileMover();

        private SaveLoadTileMover() {
        }

        public boolean canMove(Level w, BlockPos pos) {
            return true;
        }

        public void move(Level w, BlockPos pos, Direction dir) {
            LevelChunk chunk = w.getChunkAt(pos);
            BlockPos pos2 = pos.relative(dir);
            LevelChunk chunk2 = w.getChunkAt(pos2);
            BlockState state = w.getBlockState(pos);
            CompoundTag tag = chunk.getBlockEntityNbtForSaving(pos, (HolderLookup.Provider)w.registryAccess());
            MovementRegistry.silentSetBlockState(chunk, pos, Blocks.AIR.defaultBlockState());
            chunk.removeBlockEntity(pos);
            MovementRegistry.silentSetBlockState(chunk2, pos2, state);
            if (tag != null) {
                tag.putInt("x", pos2.getX());
                tag.putInt("y", pos2.getY());
                tag.putInt("z", pos2.getZ());
                chunk2.setBlockEntityNbt(tag);
            }
        }

        public void postMove(Level w, BlockPos pos) {
            LevelChunk chunk = w.getChunkAt(pos);
            chunk.getBlockEntity(pos);
        }
    }
}

