/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.graphs;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mrtjp.projectred.expansion.ProjectRedExpansion;
import mrtjp.projectred.expansion.graphs.GraphContainer;
import mrtjp.projectred.expansion.graphs.GraphLink;
import mrtjp.projectred.expansion.graphs.GraphLinkPathfinder;
import mrtjp.projectred.expansion.graphs.GraphNodePathfinder;
import mrtjp.projectred.expansion.graphs.GraphRoutePathfinder;
import mrtjp.projectred.expansion.graphs.GraphRouteTable;

public class GraphNode {
    public final GraphContainer container;
    private boolean isActive = false;
    private List<GraphLink> links = new LinkedList<GraphLink>();
    private boolean linksNeedRefresh = false;
    @Nullable
    private GraphRouteTable routeTable;

    public GraphNode(GraphContainer container) {
        this.container = container;
    }

    public List<GraphLink> getLinks() {
        if (this.linksNeedRefresh) {
            boolean wasActive = this.isActive;
            boolean linksChanged = this.refreshLinks();
            boolean stateChanged = wasActive == !this.isActive;
            this.linksNeedRefresh = false;
            if (linksChanged || stateChanged) {
                ProjectRedExpansion.LOGGER.debug("Container {} node change: links: {}, state: {}", (Object)this.container.hashCode(), (Object)linksChanged, (Object)stateChanged);
                this.container.onNodeChanged(linksChanged, stateChanged);
            }
        }
        return this.links;
    }

    public GraphRouteTable getRouteTable() {
        if (this.routeTable == null) {
            this.routeTable = new GraphRoutePathfinder(this).result();
        }
        return this.routeTable;
    }

    public Optional<List<GraphLink>> getLinksIfPresent() {
        return this.linksNeedRefresh ? Optional.empty() : Optional.of(this.links);
    }

    public Optional<GraphRouteTable> getRouteTableIfPresent() {
        return this.routeTable == null ? Optional.empty() : Optional.of(this.routeTable);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void onTick() {
        this.getLinks();
    }

    public void markLinksChanged() {
        this.linksNeedRefresh = true;
        this.routeTable = null;
    }

    public void markRouteTableChanged() {
        this.routeTable = null;
    }

    public void onAdded() {
        this.getLinks();
        if (!this.isActive) {
            GraphLinkPathfinder pathfinder = new GraphLinkPathfinder(this.container);
            List<GraphLink> result = pathfinder.result();
            ProjectRedExpansion.LOGGER.debug("onAdded: Marking {} links for updates", (Object)result.size());
            this.notifyAllLinks(result);
        }
    }

    public int onRemoved() {
        GraphLinkPathfinder pathfinder = new GraphLinkPathfinder(this.container);
        List<GraphLink> result = pathfinder.result();
        int sideMask = 0;
        for (GraphLink link : result) {
            sideMask |= 1 << link.direction();
        }
        ProjectRedExpansion.LOGGER.debug("onRemoved: Marking {} links (mask {}) for updates", (Object)result.size(), (Object)sideMask);
        if (!result.isEmpty()) {
            this.notifyAllLinks(result);
        }
        return sideMask;
    }

    private boolean refreshLinks() {
        boolean wasActive = this.isActive;
        this.isActive = this.container.requiresActiveNode();
        if (!wasActive && this.isActive) {
            ProjectRedExpansion.LOGGER.debug("node {} going active", (Object)this.container.hashCode());
            assert (this.links.isEmpty());
            GraphLinkPathfinder pathfinder = new GraphLinkPathfinder(this.container);
            List<GraphLink> newLinks = pathfinder.result();
            if (!newLinks.isEmpty()) {
                this.links = newLinks;
                this.invalidateRoutes(this.links);
                this.notifyAllLinks(this.links);
                return true;
            }
        } else if (wasActive && !this.isActive) {
            ProjectRedExpansion.LOGGER.debug("node {} going inactive", (Object)this.container.hashCode());
            if (!this.links.isEmpty()) {
                List<GraphLink> oldLinks = this.links;
                this.links = List.of();
                this.notifyAllLinks(oldLinks);
                return true;
            }
        } else if (this.isActive) {
            ProjectRedExpansion.LOGGER.debug("node {} updating links", (Object)this.container.hashCode());
            GraphLinkPathfinder pathfinder = new GraphLinkPathfinder(this.container);
            List<GraphLink> newLinks = pathfinder.result();
            if (!this.linksEqual(this.links, newLinks)) {
                List<GraphLink> oldLinks = this.links;
                this.links = newLinks;
                this.invalidateRoutes(this.links);
                this.notifyChangedLinks(oldLinks, this.links);
                return true;
            }
        }
        return false;
    }

    private boolean linksEqual(List<GraphLink> a, List<GraphLink> b) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<GraphLink> aIter = a.iterator();
        Iterator<GraphLink> bIter = b.iterator();
        while (aIter.hasNext()) {
            if (aIter.next().equals(bIter.next())) continue;
            return false;
        }
        return true;
    }

    private void notifyAllLinks(List<GraphLink> links) {
        for (GraphLink link : links) {
            ProjectRedExpansion.LOGGER.debug("notifying link {}", (Object)link.to().hashCode());
            link.to().getNode().markLinksChanged();
        }
    }

    private void invalidateRoutes(List<GraphLink> links) {
        Collection<GraphNode> allNodes = new GraphNodePathfinder(links.stream().map(l -> l.to().getNode()).toList()).result();
        int[] start = links.stream().mapToInt(l -> l.to().hashCode()).toArray();
        int[] res = allNodes.stream().mapToInt(n -> n.container.hashCode()).toArray();
        ProjectRedExpansion.LOGGER.debug("invalidating routes for {} total nodes: {} -> {}", (Object)allNodes.size(), (Object)start, (Object)res);
        allNodes.forEach(GraphNode::markRouteTableChanged);
    }

    private void notifyChangedLinks(List<GraphLink> oldLinks, List<GraphLink> newLinks) {
        for (GraphLink link : oldLinks) {
            if (newLinks.contains(link)) continue;
            ProjectRedExpansion.LOGGER.debug("notifying removed link {}", (Object)link.to().hashCode());
            link.to().getNode().markLinksChanged();
        }
        for (GraphLink link : newLinks) {
            if (oldLinks.contains(link)) continue;
            ProjectRedExpansion.LOGGER.debug("notifying added link {}", (Object)link.to().hashCode());
            link.to().getNode().markLinksChanged();
        }
    }

    public String toString() {
        return "GraphNode{container=" + this.container.hashCode() + ", links=" + String.valueOf(this.links) + ", isRedundant=" + !this.isActive + ", linksNeedRefresh=" + this.linksNeedRefresh + "}";
    }
}

