/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.pneumatics;

import java.util.Deque;
import java.util.LinkedList;
import javax.annotation.Nullable;
import mrtjp.projectred.expansion.part.PneumaticTubePayload;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class PneumaticQueue {
    private final Deque<PneumaticTubePayload> queue = new LinkedList<PneumaticTubePayload>();
    private boolean backStuffed = false;

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public void add(PneumaticTubePayload payload) {
        this.queue.addLast(payload);
    }

    public void addBackStuffed(PneumaticTubePayload payload) {
        this.queue.addFirst(payload);
        this.backStuffed = true;
    }

    public boolean isBackStuffed() {
        return this.backStuffed;
    }

    @Nullable
    public PneumaticTubePayload poll() {
        PneumaticTubePayload out = this.queue.pollFirst();
        if (this.queue.isEmpty()) {
            this.backStuffed = false;
        }
        return out;
    }

    public void save(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        ListTag payloads = new ListTag();
        for (PneumaticTubePayload payload : this.queue) {
            CompoundTag payloadTag = new CompoundTag();
            payload.save(payloadTag, lookupProvider);
            payloads.add((Object)payloadTag);
        }
        tag.put("payloads", (Tag)payloads);
        tag.putBoolean("backstuffed", this.backStuffed);
    }

    public void load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.queue.clear();
        ListTag payloads = tag.getList("payloads", 10);
        for (int i = 0; i < payloads.size(); ++i) {
            CompoundTag payloadTag = payloads.getCompound(i);
            PneumaticTubePayload payload = new PneumaticTubePayload();
            payload.load(payloadTag, lookupProvider);
            this.queue.addLast(payload);
        }
        this.backStuffed = tag.getBoolean("backstuffed");
    }
}

