/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.simulate.ByteRegister;
import mrtjp.projectred.fabrication.engine.ICSimulationContainer;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.SidedRedstoneGateTile;
import net.minecraft.nbt.CompoundTag;

public abstract class InternalStateGateTile
extends SidedRedstoneGateTile {
    public static final int STATE2_PACKET = 6;
    protected int stateReg = -1;
    private byte state2 = 0;

    public InternalStateGateTile(ICGateTileType gateType) {
        super(gateType);
    }

    public int getState2() {
        return this.state2 & 0xFF;
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.putByte("state2", this.state2);
        tag.putInt("regS", this.stateReg);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.state2 = tag.getByte("state2");
        this.stateReg = tag.getInt("regS");
    }

    @Override
    public void writeDesc(MCDataOutput out) {
        super.writeDesc(out);
        out.writeByte((int)this.state2);
    }

    @Override
    public void readDesc(MCDataInput in) {
        super.readDesc(in);
        this.state2 = in.readByte();
    }

    @Override
    public void read(MCDataInput in, int key) {
        switch (key) {
            case 6: {
                this.state2 = in.readByte();
                break;
            }
            default: {
                super.read(in, key);
            }
        }
    }

    protected void sendState2Update() {
        this.getWriteStream(6).writeByte((int)this.state2);
    }

    @Override
    public void onSimRegistersChanged(int rMask, ICSimulationContainer container) {
        super.onSimRegistersChanged(rMask, container);
        byte oldS2 = this.state2;
        this.state2 = container.pullRegisterValue(this.stateReg);
        if (oldS2 != this.state2) {
            this.sendState2Update();
        }
    }

    @Override
    protected void clearRegisterIds() {
        super.clearRegisterIds();
        this.stateReg = -1;
    }

    @Override
    public void allocate(ICAssemblyTile.Allocator allocator) {
        super.allocate(allocator);
        this.stateReg = allocator.allocRegisterID();
    }

    @Override
    public void consumeRemaps(ICAssemblyTile.RemapProvider remapProvider) {
        super.consumeRemaps(remapProvider);
        this.stateReg = remapProvider.getRemappedRegisterID(this.stateReg);
    }

    @Override
    public void collect(ICAssemblyTile.Collector collector) {
        super.collect(collector);
        collector.addRegister(this.stateReg, new ByteRegister());
    }
}

