/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import java.util.Arrays;
import java.util.Optional;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.api.IPathFinder;
import mrtjp.fengine.assemble.PathFinderResult;
import mrtjp.fengine.simulate.ByteRegister;
import mrtjp.projectred.fabrication.engine.ICSimulationContainer;
import mrtjp.projectred.fabrication.engine.IRotatableICTile;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.RedstoneGateTile;
import mrtjp.projectred.fabrication.engine.log.DeadGateWarning;
import mrtjp.projectred.fabrication.engine.log.MultipleDriversError;
import net.minecraft.nbt.CompoundTag;

public abstract class SidedRedstoneGateTile
extends RedstoneGateTile {
    private final int[] inputRegisters = new int[]{-1, -1, -1, -1};
    private final int[] outputRegisters = new int[]{-1, -1, -1, -1};
    private int gateId = -1;

    public SidedRedstoneGateTile(ICGateTileType gateType) {
        super(gateType);
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        for (int i = 0; i < 4; ++i) {
            tag.putInt("regIn" + i, this.inputRegisters[i]);
            tag.putInt("regOut" + i, this.outputRegisters[i]);
        }
        tag.putInt("gate", this.gateId);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        for (int i = 0; i < 4; ++i) {
            this.inputRegisters[i] = tag.getInt("regIn" + i);
            this.outputRegisters[i] = tag.getInt("regOut" + i);
        }
        this.gateId = tag.getInt("gate");
    }

    @Override
    public void onSimRegistersChanged(int rMask, ICSimulationContainer container) {
        int newState;
        int oldState = this.getState();
        if (oldState != (newState = this.pullInputMask(container) & 0xF | this.pullOutputMask(container) << 4)) {
            this.setState(newState);
            this.sendStateUpdate();
        }
    }

    protected int pullInputMask(ICSimulationContainer container) {
        int mask = 0;
        for (int r = 0; r < 4; ++r) {
            int regId;
            if (!this.canInputRedstone(r) || container.pullRegisterValue(regId = this.inputRegisters[r]) == 0) continue;
            mask |= 1 << r;
        }
        return mask;
    }

    protected int pullOutputMask(ICSimulationContainer container) {
        int mask = 0;
        for (int r = 0; r < 4; ++r) {
            int regId;
            if (!this.canOutputRedstone(r) || container.pullRegisterValue(regId = this.outputRegisters[r]) == 0) continue;
            mask |= 1 << r;
        }
        return mask;
    }

    @Override
    public void allocate(ICAssemblyTile.Allocator allocator) {
        this.clearRegisterIds();
        for (int r = 0; r < 4; ++r) {
            if (!this.canOutputRedstone(r)) continue;
            this.outputRegisters[r] = allocator.allocRegisterID();
        }
        this.gateId = allocator.allocGateID();
    }

    @Override
    public void locate(IPathFinder pathFinder) {
        int req = 0;
        int found = 0;
        for (int r = 0; r < 4; ++r) {
            if (!this.canInputRedstone(r)) continue;
            ++req;
            this.inputRegisters[r] = this.searchInputRegister(r, pathFinder);
            if (this.inputRegisters[r] == 136) continue;
            ++found;
        }
        if (req > 0 && found == 0) {
            this.getEditor().getStateMachine().getCompilerLog().addProblem(new DeadGateWarning(this.getPos()));
        }
    }

    @Override
    public void consumeRemaps(ICAssemblyTile.RemapProvider remapProvider) {
        for (int r = 0; r < 4; ++r) {
            if (this.inputRegisters[r] != -1) {
                this.inputRegisters[r] = remapProvider.getRemappedRegisterID(this.inputRegisters[r]);
            }
            if (this.outputRegisters[r] == -1) continue;
            this.outputRegisters[r] = remapProvider.getRemappedRegisterID(this.outputRegisters[r]);
        }
    }

    @Override
    public void collect(ICAssemblyTile.Collector collector) {
        for (int r = 0; r < 4; ++r) {
            if (this.outputRegisters[r] == -1) continue;
            collector.addRegister(this.outputRegisters[r], new ByteRegister());
        }
        this.collectGate(collector, this.gateId, this.inputRegisters, this.outputRegisters);
    }

    @Override
    public Optional<Integer> getOutputRegister(int outDir, int outPort) {
        int absR = IRotatableICTile.dirToRotation(outDir);
        int r = this.toInternalRotation(absR);
        if (r == -1 || this.outputRegisters[r] == -1) {
            return Optional.empty();
        }
        return Optional.of(this.outputRegisters[r]);
    }

    @Override
    public Optional<Integer> getInputRegister(int inDir, int inPort) {
        int absR = IRotatableICTile.dirToRotation(inDir);
        int r = this.toInternalRotation(absR);
        if (r == -1 || this.inputRegisters[r] == -1) {
            return Optional.empty();
        }
        return Optional.of(this.inputRegisters[r]);
    }

    protected void clearRegisterIds() {
        Arrays.fill(this.inputRegisters, -1);
        Arrays.fill(this.outputRegisters, -1);
    }

    private int searchInputRegister(int r, IPathFinder pathFinder) {
        int absR = this.toAbsoluteRotation(r);
        int absDir = IRotatableICTile.rotationToDir(absR);
        PathFinderResult pfr = pathFinder.doPathFinding((d, p) -> d == absDir);
        if (pfr.outputRegisters.size() > 1) {
            this.getEditor().getStateMachine().getCompilerLog().addProblem(new MultipleDriversError(this.getPos(), pfr.outputRegisters));
        }
        if (!pfr.outputRegisters.isEmpty()) {
            return pfr.outputRegisters.get(0);
        }
        return 136;
    }

    protected abstract void collectGate(ICAssemblyTile.Collector var1, int var2, int[] var3, int[] var4);
}

