/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import java.util.Arrays;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.simulate.ByteRegister;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.InternalStateGateTile;
import net.minecraft.nbt.CompoundTag;

public abstract class TimedStateGateTile
extends InternalStateGateTile {
    protected int[] timeRegs = new int[8];

    public TimedStateGateTile(ICGateTileType gateType) {
        super(gateType);
        Arrays.fill(this.timeRegs, -1);
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.putInt("regS", this.stateReg);
        tag.putIntArray("reg_time", this.timeRegs);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.stateReg = tag.getInt("regS");
        this.timeRegs = tag.getIntArray("reg_time");
    }

    @Override
    protected void clearRegisterIds() {
        super.clearRegisterIds();
        Arrays.fill(this.timeRegs, -1);
    }

    @Override
    public void allocate(ICAssemblyTile.Allocator allocator) {
        super.allocate(allocator);
        for (int i = 0; i < 8; ++i) {
            this.timeRegs[i] = allocator.allocRegisterID();
        }
    }

    @Override
    public void consumeRemaps(ICAssemblyTile.RemapProvider remapProvider) {
        super.consumeRemaps(remapProvider);
        for (int i = 0; i < 8; ++i) {
            this.timeRegs[i] = remapProvider.getRemappedRegisterID(this.timeRegs[i]);
        }
    }

    @Override
    public void collect(ICAssemblyTile.Collector collector) {
        super.collect(collector);
        for (int timeReg : this.timeRegs) {
            collector.addRegister(timeReg, new ByteRegister());
        }
    }
}

