/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.log;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mrtjp.fengine.TileCoord;
import mrtjp.fengine.api.ICStepThroughAssembler;
import mrtjp.projectred.fabrication.editor.ICEditorStateMachine;
import mrtjp.projectred.fabrication.engine.log.CompileProblem;
import mrtjp.projectred.fabrication.engine.log.CompileProblemType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class ICCompilerLog
implements ICStepThroughAssembler.EventReceiver {
    private final ICEditorStateMachine stateMachine;
    private final CompileTree compileTree = new CompileTree();
    private final List<Integer> currentPath = new LinkedList<Integer>();
    private int completedSteps = 0;
    private final List<CompileProblem> problems = new ArrayList<CompileProblem>();
    private int warningCount = 0;
    private int errorCount = 0;
    private final List<Runnable> treeChangedListeners = new LinkedList<Runnable>();

    public ICCompilerLog(ICEditorStateMachine stateMachine) {
        this.stateMachine = stateMachine;
    }

    public void save(CompoundTag tag) {
        tag.putInt("completed_steps", this.completedSteps);
        tag.putIntArray("current_path", this.currentPath);
        this.compileTree.save(tag);
        ListTag list = new ListTag();
        for (CompileProblem problem : this.problems) {
            CompoundTag problemTag = new CompoundTag();
            problemTag.putByte("_type", (byte)problem.type.getID());
            problem.save(problemTag);
            list.add((Object)problemTag);
        }
        tag.put("problems", (Tag)list);
        tag.putInt("warning_count", this.warningCount);
        tag.putInt("error_count", this.errorCount);
    }

    public void load(CompoundTag tag) {
        this.completedSteps = tag.getInt("completed_steps");
        this.currentPath.clear();
        this.currentPath.addAll(Arrays.stream(tag.getIntArray("current_path")).boxed().toList());
        this.compileTree.load(tag);
        ListTag list = tag.getList("problems", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag problemTag = list.getCompound(i);
            CompileProblem problem = CompileProblemType.createById(problemTag.getByte("_type") & 0xFF);
            problem.load(problemTag);
            this.addProblemInternal(problem);
        }
    }

    public void writeDesc(MCDataOutput out) {
        this.compileTree.writeDesc(out);
        out.writeInt(this.completedSteps);
        out.writeInt(this.currentPath.size());
        Iterator<Object> iterator = this.currentPath.iterator();
        while (iterator.hasNext()) {
            int i = iterator.next();
            out.writeInt(i);
        }
        out.writeVarInt(this.problems.size());
        for (CompileProblem problem : this.problems) {
            out.writeByte(problem.type.getID());
            problem.writeDesc(out);
        }
    }

    public void readDesc(MCDataInput in) {
        int i;
        this.clear();
        this.compileTree.readDesc(in);
        this.completedSteps = in.readInt();
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            this.currentPath.add(in.readInt());
        }
        size = in.readVarInt();
        for (i = 0; i < size; ++i) {
            CompileProblem problem = CompileProblemType.createById(in.readUByte());
            problem.readDesc(in);
            this.addProblemInternal(problem);
        }
    }

    public void clear() {
        this.compileTree.clear();
        this.currentPath.clear();
        this.completedSteps = 0;
        this.problems.clear();
        this.warningCount = 0;
        this.errorCount = 0;
        this.notifyListeners();
    }

    public int getTotalSteps() {
        return this.compileTree.size();
    }

    public int getCompletedSteps() {
        return this.completedSteps;
    }

    public List<CompileProblem> getProblems() {
        return this.problems;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void addTreeChangedListener(Runnable listener) {
        this.treeChangedListeners.add(listener);
    }

    private void notifyListeners() {
        for (Runnable listener : this.treeChangedListeners) {
            listener.run();
        }
    }

    @Override
    public void onStepAdded(ICStepThroughAssembler.AssemblerStepDescriptor descriptor) {
        CompileTreeNode node = this.compileTree.findOrCreateNode(descriptor.getTreePath());
        node.step = descriptor.getStepType();
        this.sendNodeAdded(node, descriptor.getTreePath());
        this.notifyListeners();
    }

    @Override
    public void onStepExecuted(ICStepThroughAssembler.AssemblerStepResult result) {
        CompileTreeNode node = this.compileTree.findOrCreateNode(result.getTreePath());
        node.tileCoords.addAll(result.getTileCoords());
        node.registerIds.addAll(result.getRegisterIds());
        node.gateIds.addAll(result.getGateIds());
        node.registerRemaps.putAll(result.getRemappedRegisterIds());
        this.currentPath.clear();
        this.currentPath.addAll(result.getTreePath());
        ++this.completedSteps;
        this.sendNodeExecuted(node, result.getTreePath());
        this.notifyListeners();
    }

    public void clearAndSend() {
        this.clear();
        this.sendClear();
    }

    public void addProblem(CompileProblem problem) {
        this.addProblemInternal(problem);
        this.sendProblemAdded(problem);
    }

    public void readLogStream(MCDataInput in, int key) {
        switch (key) {
            case 1: {
                this.clear();
                break;
            }
            case 2: {
                this.readNodeAdded(in);
                break;
            }
            case 3: {
                this.readNodeExecuted(in);
                break;
            }
            case 4: {
                this.readProblemAdded(in);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown compiler stream key: " + key);
            }
        }
    }

    private void sendClear() {
        this.stateMachine.getStateMachineStream(1);
    }

    private void sendNodeAdded(CompileTreeNode node, List<Integer> treePath) {
        MCDataOutput out = this.stateMachine.getStateMachineStream(2);
        out.writeByte(treePath.size());
        for (int i : treePath) {
            out.writeByte(i);
        }
        out.writeByte(node.step.ordinal());
    }

    private void sendNodeExecuted(CompileTreeNode node, List<Integer> treePath) {
        MCDataOutput out = this.stateMachine.getStateMachineStream(3);
        out.writeByte(treePath.size());
        for (int i : treePath) {
            out.writeByte(i);
        }
        node.write(out);
    }

    private void sendProblemAdded(CompileProblem problem) {
        MCDataOutput out = this.stateMachine.getStateMachineStream(4);
        out.writeByte(problem.type.ordinal());
        problem.writeDesc(out);
    }

    private void addProblemInternal(CompileProblem problem) {
        this.problems.add(problem);
        switch (problem.severity) {
            case WARNING: {
                ++this.warningCount;
                break;
            }
            case ERROR: {
                ++this.errorCount;
            }
        }
        this.notifyListeners();
    }

    private void readNodeAdded(MCDataInput in) {
        int pathLength = in.readUByte();
        ArrayList<Integer> path = new ArrayList<Integer>(pathLength);
        for (int i = 0; i < pathLength; ++i) {
            path.add(Integer.valueOf(in.readUByte()));
        }
        CompileTreeNode node = this.compileTree.findOrCreateNode(path);
        node.step = ICStepThroughAssembler.AssemblerStepType.values()[in.readUByte()];
        this.notifyListeners();
    }

    private void readNodeExecuted(MCDataInput in) {
        int pathLength = in.readUByte();
        ArrayList<Integer> path = new ArrayList<Integer>(pathLength);
        for (int i = 0; i < pathLength; ++i) {
            path.add(Integer.valueOf(in.readUByte()));
        }
        CompileTreeNode node = this.compileTree.findOrCreateNode(path);
        node.read(in);
        this.currentPath.clear();
        this.currentPath.addAll(path);
        ++this.completedSteps;
        this.notifyListeners();
    }

    private void readProblemAdded(MCDataInput in) {
        CompileProblem problem = CompileProblemType.createById(in.readUByte());
        problem.readDesc(in);
        this.addProblemInternal(problem);
    }

    public List<CompileTreeNode> getCurrentStack() {
        return this.compileTree.getStack(this.currentPath);
    }

    public List<CompileTreeNode> getRootNodes() {
        return this.compileTree.rootNodes;
    }

    public int getProgressScaled(int scale) {
        int size = this.compileTree.size();
        return size == 0 ? 0 : this.completedSteps * scale / size;
    }

    public static class CompileTree {
        private final List<CompileTreeNode> rootNodes = new ArrayList<CompileTreeNode>();
        private int size = 0;

        public CompileTreeNode findOrCreateNode(List<Integer> path) {
            CompileTreeNode node;
            Iterator<Integer> pathIterator = path.iterator();
            int ri = pathIterator.next();
            CompileTreeNode compileTreeNode = node = ri < this.rootNodes.size() ? this.rootNodes.get(ri) : null;
            if (node == null) {
                node = new CompileTreeNode();
                this.rootNodes.add(ri, node);
                ++this.size;
            }
            while (pathIterator.hasNext()) {
                CompileTreeNode next;
                int i = pathIterator.next();
                CompileTreeNode compileTreeNode2 = next = i < node.children.size() ? node.children.get(i) : null;
                if (next == null) {
                    next = new CompileTreeNode();
                    node.children.add(i, next);
                    ++this.size;
                }
                node = next;
            }
            return node;
        }

        public List<CompileTreeNode> getStack(List<Integer> path) {
            CompileTreeNode node;
            if (path.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<CompileTreeNode> stack = new ArrayList<CompileTreeNode>(path.size());
            Iterator<Integer> pathIterator = path.iterator();
            int ri = pathIterator.next();
            CompileTreeNode compileTreeNode = node = ri < this.rootNodes.size() ? this.rootNodes.get(ri) : null;
            if (node == null) {
                return stack;
            }
            stack.add(node);
            while (pathIterator.hasNext()) {
                CompileTreeNode next;
                int i = pathIterator.next();
                CompileTreeNode compileTreeNode2 = next = i < node.children.size() ? node.children.get(i) : null;
                if (next == null) {
                    return stack;
                }
                stack.add(next);
                node = next;
            }
            return stack;
        }

        public int size() {
            return this.size;
        }

        public void clear() {
            this.rootNodes.clear();
            this.size = 0;
        }

        public void save(CompoundTag tag) {
            tag.putInt("size", this.size);
            ListTag rootNodesTag = new ListTag();
            for (CompileTreeNode rootNode : this.rootNodes) {
                CompoundTag rootNodeTag = new CompoundTag();
                rootNode.save(rootNodeTag);
                rootNodesTag.add((Object)rootNodeTag);
            }
            tag.put("rootNodes", (Tag)rootNodesTag);
        }

        public void load(CompoundTag tag) {
            this.size = tag.getInt("size");
            this.rootNodes.clear();
            ListTag rootNodesTag = tag.getList("rootNodes", 10);
            for (Tag rootNodeTag : rootNodesTag) {
                CompileTreeNode rootNode = new CompileTreeNode();
                rootNode.load((CompoundTag)rootNodeTag);
                this.rootNodes.add(rootNode);
            }
        }

        public void writeDesc(MCDataOutput out) {
            out.writeVarInt(this.size);
            out.writeByte(this.rootNodes.size());
            for (CompileTreeNode node : this.rootNodes) {
                node.writeDesc(out);
            }
        }

        public void readDesc(MCDataInput in) {
            this.size = in.readVarInt();
            int size = in.readUByte();
            this.rootNodes.clear();
            for (int i = 0; i < size; ++i) {
                CompileTreeNode node = new CompileTreeNode();
                node.readDesc(in);
                this.rootNodes.add(node);
            }
        }
    }

    public static class CompileTreeNode {
        public final List<CompileTreeNode> children = new ArrayList<CompileTreeNode>();
        public ICStepThroughAssembler.AssemblerStepType step = ICStepThroughAssembler.AssemblerStepType.CHECK_OPEN_TILE_MAPS;
        public final List<TileCoord> tileCoords = new ArrayList<TileCoord>();
        public final List<Integer> registerIds = new ArrayList<Integer>();
        public final List<Integer> gateIds = new ArrayList<Integer>();
        public final Map<Integer, Integer> registerRemaps = new HashMap<Integer, Integer>();

        public void save(CompoundTag tag) {
            tag.putByte("step", (byte)this.step.ordinal());
            ListTag tileCoordsTag = new ListTag();
            for (TileCoord tileCoord : this.tileCoords) {
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.putByte("x", (byte)tileCoord.x);
                compoundTag.putByte("y", (byte)tileCoord.y);
                compoundTag.putByte("z", (byte)tileCoord.z);
                tileCoordsTag.add((Object)compoundTag);
            }
            tag.put("tileCoords", (Tag)tileCoordsTag);
            tag.putIntArray("registerIds", this.registerIds);
            tag.putIntArray("gateIds", this.gateIds);
            ListTag remapsTag = new ListTag();
            for (Map.Entry<Integer, Integer> entry : this.registerRemaps.entrySet()) {
                CompoundTag remapTag = new CompoundTag();
                remapTag.putInt("k", entry.getKey().intValue());
                remapTag.putInt("v", entry.getValue().intValue());
                remapsTag.add((Object)remapTag);
            }
            tag.put("registerRemaps", (Tag)remapsTag);
            ListTag listTag = new ListTag();
            for (CompileTreeNode child : this.children) {
                CompoundTag childTag = new CompoundTag();
                child.save(childTag);
                listTag.add((Object)childTag);
            }
            tag.put("children", (Tag)listTag);
        }

        public void load(CompoundTag tag) {
            this.step = ICStepThroughAssembler.AssemblerStepType.values()[tag.getByte("step")];
            ListTag tileCoordsTag = tag.getList("tileCoords", 10);
            for (Object coordTag : tileCoordsTag) {
                CompoundTag coordTagCompound = (CompoundTag)coordTag;
                this.tileCoords.add(new TileCoord(coordTagCompound.getByte("x"), coordTagCompound.getByte("y"), coordTagCompound.getByte("z")));
            }
            this.registerIds.addAll(Arrays.stream(tag.getIntArray("registerIds")).boxed().toList());
            this.gateIds.addAll(Arrays.stream(tag.getIntArray("gateIds")).boxed().toList());
            ListTag remapsTag = tag.getList("registerRemaps", 10);
            for (Tag remapTag : remapsTag) {
                CompoundTag remapTagCompound = (CompoundTag)remapTag;
                this.registerRemaps.put(remapTagCompound.getInt("k"), remapTagCompound.getInt("v"));
            }
            this.children.clear();
            ListTag childrenTag = tag.getList("children", 10);
            for (Tag childTag : childrenTag) {
                CompileTreeNode child = new CompileTreeNode();
                child.load((CompoundTag)childTag);
                this.children.add(child);
            }
        }

        public void write(MCDataOutput out) {
            out.writeByte(this.step.ordinal());
            out.writeByte(this.tileCoords.size());
            for (TileCoord coord : this.tileCoords) {
                out.writeByte(coord.x).writeByte(coord.y).writeByte(coord.z);
            }
            out.writeByte(this.registerIds.size());
            Iterator<Object> iterator = this.registerIds.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                out.writeVarInt(i);
            }
            out.writeByte(this.gateIds.size());
            iterator = this.gateIds.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                out.writeVarInt(i);
            }
            out.writeByte(this.registerRemaps.size());
            this.registerRemaps.forEach((k, v) -> {
                out.writeVarInt(k.intValue());
                out.writeVarInt(v.intValue());
            });
        }

        public void read(MCDataInput in) {
            int i;
            this.step = ICStepThroughAssembler.AssemblerStepType.values()[in.readUByte()];
            int size = in.readUByte();
            this.tileCoords.clear();
            for (i = 0; i < size; ++i) {
                this.tileCoords.add(new TileCoord(in.readByte(), in.readByte(), in.readByte()));
            }
            size = in.readUByte();
            this.registerIds.clear();
            for (i = 0; i < size; ++i) {
                this.registerIds.add(in.readVarInt());
            }
            size = in.readVarInt();
            this.gateIds.clear();
            for (i = 0; i < size; ++i) {
                this.gateIds.add(in.readVarInt());
            }
            size = in.readVarInt();
            this.registerRemaps.clear();
            for (i = 0; i < size; ++i) {
                this.registerRemaps.put(in.readVarInt(), in.readVarInt());
            }
        }

        protected void writeDesc(MCDataOutput out) {
            this.write(out);
            out.writeByte(this.children.size());
            for (CompileTreeNode child : this.children) {
                child.writeDesc(out);
            }
        }

        protected void readDesc(MCDataInput in) {
            this.read(in);
            this.children.clear();
            int size = in.readUByte();
            for (int i = 0; i < size; ++i) {
                CompileTreeNode child = new CompileTreeNode();
                child.readDesc(in);
                this.children.add(child);
            }
        }

        public int countRegIdsInSubtree() {
            int count = this.registerIds.size();
            for (CompileTreeNode child : this.children) {
                count += child.countRegIdsInSubtree();
            }
            return count;
        }

        public int countGateIdsInSubtree() {
            int count = this.gateIds.size();
            for (CompileTreeNode child : this.children) {
                count += child.countGateIdsInSubtree();
            }
            return count;
        }

        public int countRemapsInSubtree() {
            int count = this.registerRemaps.size();
            for (CompileTreeNode child : this.children) {
                count += child.countRemapsInSubtree();
            }
            return count;
        }

        public boolean isEmpty() {
            return this.registerIds.isEmpty() && this.gateIds.isEmpty() && this.registerRemaps.isEmpty();
        }

        public void getPositionsInTree(List<TileCoord> pList) {
            if (!this.isEmpty()) {
                pList.addAll(this.tileCoords);
                for (CompileTreeNode child : this.children) {
                    child.getPositionsInTree(pList);
                }
            }
        }
    }
}

