/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.log;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mrtjp.fengine.TileCoord;
import mrtjp.projectred.fabrication.editor.EditorDataUtils;
import mrtjp.projectred.fabrication.engine.log.CompileProblem;
import mrtjp.projectred.fabrication.engine.log.CompileProblemSeverity;
import mrtjp.projectred.fabrication.engine.log.CompileProblemType;
import mrtjp.projectred.fabrication.gui.ICRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public abstract class SimpleLocatableProblem
extends CompileProblem {
    public TileCoord coord = TileCoord.origin;

    public SimpleLocatableProblem(CompileProblemType type, CompileProblemSeverity severity) {
        super(type, severity);
    }

    public SimpleLocatableProblem(CompileProblemType type, CompileProblemSeverity severity, TileCoord coord) {
        this(type, severity);
        this.coord = coord;
    }

    @Override
    public void save(CompoundTag tag) {
        tag.put("coord", (Tag)EditorDataUtils.tileCoordToNBT(this.coord));
    }

    @Override
    public void load(CompoundTag tag) {
        this.coord = EditorDataUtils.tileCoordFromNBT(tag.getCompound("coord"));
    }

    @Override
    public void writeDesc(MCDataOutput out) {
        out.writeByte(this.coord.x).writeByte(this.coord.y).writeByte(this.coord.z);
    }

    @Override
    public void readDesc(MCDataInput in) {
        this.coord = new TileCoord(in.readByte(), in.readByte(), in.readByte());
    }

    @Override
    public void buildToolTip(List<Component> tooltip, TileCoord hoverPosition) {
        if (this.coord.equals(hoverPosition)) {
            this.buildToolTip(tooltip);
        }
    }

    @Override
    public void renderOverlay(Vector3 mousePosition, CCRenderState ccrs, MultiBufferSource getter, PoseStack matrixStack) {
        ccrs.baseColour = this.severity == CompileProblemSeverity.ERROR ? EnumColour.RED.rgba(200) : EnumColour.YELLOW.rgba(200);
        Vector3 vec = new Vector3((double)this.coord.x, (double)this.coord.y, (double)this.coord.z).add(0.5);
        ICRenderTypes.renderSelection(ccrs, vec, vec, 0.1875, 0.125);
    }
}

