/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import org.joml.Matrix4f;

public class ICRenderTypes {
    public static ResourceLocation PERFBOARD_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"projectred_fabrication", (String)"textures/block/workbench_ui/perfboard.png");
    public static ResourceLocation PERFBOARD_EDGE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"projectred_fabrication", (String)"textures/block/workbench_ui/perfboard_edge.png");
    public static ResourceLocation PERFBOARD_CORNER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"projectred_fabrication", (String)"textures/block/workbench_ui/perfboard_corner.png");
    public static RenderType layersRenderType = RenderType.create((String)"projectred_fabrication:ic_block", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)10000, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_CUTOUT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.BLOCK_SHEET).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(RenderStateShard.CULL).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.NO_OVERLAY).setLayeringState(RenderStateShard.NO_LAYERING).setOutputState(RenderStateShard.MAIN_TARGET).setTexturingState(RenderStateShard.DEFAULT_TEXTURING).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLineState(RenderStateShard.DEFAULT_LINE).createCompositeState(true));
    public static RenderType selectionRenderType = RenderType.create((String)"projectred_fabrication:ic_selection", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_SHADER).setTextureState(RenderStateShard.NO_TEXTURE).setTransparencyState(RenderStateShard.LIGHTNING_TRANSPARENCY).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(RenderStateShard.CULL).setLightmapState(RenderStateShard.NO_LIGHTMAP).setOverlayState(RenderStateShard.NO_OVERLAY).setLayeringState(RenderStateShard.NO_LAYERING).setOutputState(RenderStateShard.MAIN_TARGET).setTexturingState(RenderStateShard.DEFAULT_TEXTURING).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLineState(RenderStateShard.DEFAULT_LINE).createCompositeState(true));
    public static RenderType gridRenderType = RenderType.create((String)"projectred_fabrication:ic_grid", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_CUTOUT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(PERFBOARD_TEXTURE, false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(RenderStateShard.CULL).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.NO_OVERLAY).setLayeringState(RenderStateShard.NO_LAYERING).setOutputState(RenderStateShard.MAIN_TARGET).setTexturingState(RenderStateShard.DEFAULT_TEXTURING).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLineState(RenderStateShard.DEFAULT_LINE).createCompositeState(true));
    public static RenderType gridEdgeRenderType = RenderType.create((String)"projectred_fabrication:ic_grid_edge", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_CUTOUT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(PERFBOARD_EDGE_TEXTURE, false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(RenderStateShard.CULL).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.NO_OVERLAY).setLayeringState(RenderStateShard.NO_LAYERING).setOutputState(RenderStateShard.MAIN_TARGET).setTexturingState(RenderStateShard.DEFAULT_TEXTURING).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLineState(RenderStateShard.DEFAULT_LINE).createCompositeState(true));
    public static RenderType gridCornerRenderType = RenderType.create((String)"projectred_fabrication:ic_grid_corner", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_CUTOUT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(PERFBOARD_CORNER_TEXTURE, false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(RenderStateShard.CULL).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.NO_OVERLAY).setLayeringState(RenderStateShard.NO_LAYERING).setOutputState(RenderStateShard.MAIN_TARGET).setTexturingState(RenderStateShard.DEFAULT_TEXTURING).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLineState(RenderStateShard.DEFAULT_LINE).createCompositeState(true));
    public static RenderType holoGridRenderType = RenderType.create((String)"projectred_fabrication:holo_grid_lines", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_LINES_SHADER).setTextureState(RenderStateShard.NO_TEXTURE).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(RenderStateShard.NO_CULL).setLightmapState(RenderStateShard.NO_LIGHTMAP).setOverlayState(RenderStateShard.NO_OVERLAY).setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setOutputState(RenderStateShard.MAIN_TARGET).setTexturingState(RenderStateShard.DEFAULT_TEXTURING).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).createCompositeState(false));
    public static Function<Double, RenderType> interactionZoneLinesRenderType = Util.memoize(a -> RenderType.create((String)"projectred_fabrication:interact_zone_lines", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_LINES_SHADER).setTextureState(RenderStateShard.NO_TEXTURE).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(RenderStateShard.NO_CULL).setLightmapState(RenderStateShard.NO_LIGHTMAP).setOverlayState(RenderStateShard.NO_OVERLAY).setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setOutputState(RenderStateShard.MAIN_TARGET).setTexturingState(RenderStateShard.DEFAULT_TEXTURING).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(a))).createCompositeState(false)));
    public static TextureAtlasSprite icSurfaceIcon;
    public static TextureAtlasSprite icSurfaceBorderIcon;
    public static TextureAtlasSprite icSurfaceCornerIcon;
    public static TextureAtlasSprite rotateIcon;
    public static TextureAtlasSprite reflectIcon;

    public static void renderICGrid(PoseStack renderStack, MultiBufferSource getter, Cuboid6 bounds, CCRenderState ccrs) {
        double ymin = -0.125;
        Cuboid6 box = new Cuboid6(bounds.min.x, ymin, bounds.min.z, bounds.max.x, 0.0, bounds.max.z);
        ccrs.bind(gridRenderType, getter, renderStack);
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)box, (int)1);
        double h = 0.01;
        ccrs.bind(gridEdgeRenderType, getter, renderStack);
        box.set(bounds.min.x, ymin, bounds.min.z, bounds.max.x, h, bounds.min.z + 1.0);
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)box, (int)1);
        box.set(bounds.min.x, ymin, bounds.max.z - 1.0, bounds.max.x, h, bounds.max.z);
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)box, (int)1);
        box.set(bounds.min.x, ymin, bounds.min.z, bounds.min.x + 1.0, h, bounds.max.z);
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)box, (int)1);
        box.set(bounds.max.x - 1.0, ymin, bounds.min.z, bounds.max.x, h, bounds.max.z);
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)box, (int)1);
        h = 0.02;
        ccrs.bind(gridCornerRenderType, getter, renderStack);
        box.set(bounds.min.x, ymin, bounds.min.z, bounds.min.x + 1.0, h, bounds.min.z + 1.0);
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)box, (int)1);
        box.set(bounds.max.x - 1.0, ymin, bounds.min.z, bounds.max.x, h, bounds.min.z + 1.0);
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)box, (int)1);
        box.set(bounds.max.x - 1.0, ymin, bounds.max.z - 1.0, bounds.max.x, h, bounds.max.z);
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)box, (int)1);
        box.set(bounds.min.x, ymin, bounds.max.z - 1.0, bounds.min.x + 1.0, h, bounds.max.z);
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)box, (int)1);
    }

    public static void renderSelection(CCRenderState ccrs, Vector3 a, Vector3 b, double height, double th) {
        Cuboid6 ac = new Cuboid6(a.copy().floor(), a.copy().ceil());
        ac.enclose(b.copy().floor());
        ac.enclose(b.copy().ceil());
        ac.expand(0.002);
        Cuboid6 box = new Cuboid6();
        box.min.x = ac.min.x;
        box.min.y = ac.min.y;
        box.min.z = ac.min.z;
        box.max.x = ac.max.x;
        box.max.y = ac.min.y + height;
        box.max.z = ac.min.z + th;
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)box, (int)1);
        box.min.x = ac.min.x;
        box.min.y = ac.min.y;
        box.min.z = ac.max.z - th;
        box.max.x = ac.max.x;
        box.max.y = ac.min.y + height;
        box.max.z = ac.max.z;
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)box, (int)1);
        box.min.x = ac.min.x;
        box.min.y = ac.min.y;
        box.min.z = ac.min.z + th;
        box.max.x = ac.min.x + th;
        box.max.y = ac.min.y + height;
        box.max.z = ac.max.z - th;
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)box, (int)13);
        box.min.x = ac.max.x - th;
        box.min.y = ac.min.y;
        box.min.z = ac.min.z + th;
        box.max.x = ac.max.x;
        box.max.y = ac.min.y + height;
        box.max.z = ac.max.z - th;
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)box, (int)13);
    }

    public static void renderGridInBounds(PoseStack stack, MultiBufferSource getter, Cuboid6 bounds, int amask) {
        int x;
        int z;
        VertexConsumer vertexConsumer = getter.getBuffer(holoGridRenderType);
        Matrix4f pose = stack.last().pose();
        float r = 0.7f;
        float g = 0.7f;
        float b = 0.7f;
        float alpha = 0.2f;
        if ((amask & 1) != 0) {
            int y = (int)bounds.min.y;
            while ((double)y <= bounds.max.y) {
                z = (int)bounds.min.z;
                while ((double)z <= bounds.max.z) {
                    vertexConsumer.addVertex(pose, (float)bounds.min.x, (float)y, (float)z).setColor(r, g, b, alpha).setNormal(1.0f, 0.0f, 0.0f);
                    vertexConsumer.addVertex(pose, (float)bounds.max.x, (float)y, (float)z).setColor(r, g, b, alpha).setNormal(1.0f, 0.0f, 0.0f);
                    ++z;
                }
                ++y;
            }
        }
        if ((amask & 2) != 0) {
            x = (int)bounds.min.x;
            while ((double)x <= bounds.max.x) {
                z = (int)bounds.min.z;
                while ((double)z <= bounds.max.z) {
                    vertexConsumer.addVertex(pose, (float)x, (float)bounds.min.y, (float)z).setColor(r, g, b, alpha).setNormal(0.0f, 1.0f, 0.0f);
                    vertexConsumer.addVertex(pose, (float)x, (float)bounds.max.y, (float)z).setColor(r, g, b, alpha).setNormal(0.0f, 1.0f, 0.0f);
                    ++z;
                }
                ++x;
            }
        }
        if ((amask & 4) != 0) {
            x = (int)bounds.min.x;
            while ((double)x <= bounds.max.x) {
                int y = (int)bounds.min.y;
                while ((double)y <= bounds.max.y) {
                    vertexConsumer.addVertex(pose, (float)x, (float)y, (float)bounds.min.z).setColor(r, g, b, alpha).setNormal(0.0f, 0.0f, 1.0f);
                    vertexConsumer.addVertex(pose, (float)x, (float)y, (float)bounds.max.z).setColor(r, g, b, alpha).setNormal(0.0f, 0.0f, 1.0f);
                    ++y;
                }
                ++x;
            }
        }
    }

    public static void renderCenteredTextTopOfCuboid(Component text, Cuboid6 bounds, PoseStack stack, MultiBufferSource getter) {
        double w = bounds.max.x - bounds.min.x;
        double h = bounds.max.z - bounds.min.z;
        double x = bounds.min.x + w / 2.0;
        double y = bounds.max.y + 0.002;
        double z = bounds.min.z + h / 2.0;
        ICRenderTypes.renderConstrainedCenteredText(text, stack, getter, x, y, z, w, h);
    }

    public static void renderConstrainedText(Component text, PoseStack stack, MultiBufferSource getter, double x, double y, double z, double maxW, double maxH) {
        Font fontRenderer = Minecraft.getInstance().font;
        Objects.requireNonNull(fontRenderer);
        float h = 9.0f;
        float w = fontRenderer.width((FormattedText)text);
        float s = (float)Math.min(maxW / (double)w, maxH / (double)h);
        stack.pushPose();
        stack.translate(x, y, z);
        stack.scale(s, 1.0f, s);
        stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        fontRenderer.drawInBatch(text, 0.0f, 0.0f, EnumColour.WHITE.rgba(), false, stack.last().pose(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        buffer.endBatch();
        stack.popPose();
    }

    public static void renderConstrainedCenteredText(Component text, PoseStack stack, MultiBufferSource getter, double x, double y, double z, double maxW, double maxH) {
        Font fontRenderer = Minecraft.getInstance().font;
        Objects.requireNonNull(fontRenderer);
        float h = 9.0f;
        float w = fontRenderer.width((FormattedText)text);
        float s = (float)Math.min(maxW / (double)w, maxH / (double)h);
        stack.pushPose();
        stack.translate(x, y, z);
        stack.scale(s, 1.0f, s);
        stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        float f = -fontRenderer.width((FormattedText)text) / 2;
        Objects.requireNonNull(fontRenderer);
        fontRenderer.drawInBatch(text, f, (float)(-9 / 2), EnumColour.WHITE.rgba(), false, stack.last().pose(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        buffer.endBatch();
        stack.popPose();
    }

    public void sortComponents(Cuboid6 c) {
        double tmp;
        if (c.min.x > c.max.x) {
            tmp = c.max.x;
            c.max.x = c.min.x;
            c.min.x = tmp;
        }
        if (c.min.y > c.max.y) {
            tmp = c.max.y;
            c.max.y = c.min.y;
            c.min.y = tmp;
        }
        if (c.min.z > c.max.z) {
            tmp = c.max.z;
            c.max.z = c.min.z;
            c.min.z = tmp;
        }
    }

    public static void onTextureStitchEvent(TextureAtlasStitchedEvent event) {
        if (!event.getAtlas().location().equals((Object)TextureAtlas.LOCATION_BLOCKS)) {
            return;
        }
        icSurfaceIcon = event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_fabrication", (String)"block/workbench_ui/perfboard"));
        icSurfaceBorderIcon = event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_fabrication", (String)"block/workbench_ui/perfboard_edge"));
        icSurfaceCornerIcon = event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_fabrication", (String)"block/workbench_ui/perfboard_corner"));
        rotateIcon = event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_fabrication", (String)"block/workbench_ui/rotate"));
        reflectIcon = event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_fabrication", (String)"block/workbench_ui/reflect"));
    }
}

