/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.client;

import codechicken.lib.model.PerspectiveModelState;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.uv.MultiIconTransformation;
import java.util.Objects;
import javax.annotation.Nullable;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.core.client.FullyOrientableBlockRenderer;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;

public class FrameMotorBlockRenderer
extends FullyOrientableBlockRenderer {
    public static final FrameMotorBlockRenderer INSTANCE = new FrameMotorBlockRenderer();
    private static TextureAtlasSprite topIcon;
    private static TextureAtlasSprite frontBack0Icon;
    private static TextureAtlasSprite frontBack1Icon;
    private static TextureAtlasSprite frontBack2Icon;
    private static TextureAtlasSprite leftIcon;
    private static TextureAtlasSprite rightIcon;
    private static TextureAtlasSprite bottomIcon;
    @Nullable
    private static MultiIconTransformation iconT1;
    @Nullable
    private static MultiIconTransformation iconT2;
    @Nullable
    private static MultiIconTransformation iconT3;

    public boolean canHandleBlock(BlockAndTintGetter world, BlockPos pos, BlockState blockState, @Nullable RenderType renderType) {
        return blockState.getBlock() == ExpansionBlocks.FRAME_MOTOR_BLOCK.get();
    }

    protected RenderType getBlockRenderLayer(BlockState state, BlockPos pos, BlockAndTintGetter level) {
        return RenderType.solid();
    }

    protected FullyOrientableBlockRenderer.RenderData getBlockRenderData(BlockState state, BlockPos pos, BlockAndTintGetter level) {
        this.createIconTransforms();
        int s = (Integer)state.getValue((Property)ProjectRedBlock.SIDE);
        int r = (Integer)state.getValue((Property)ProjectRedBlock.ROTATION);
        boolean isWorking = (Boolean)state.getValue((Property)ProjectRedBlock.WORKING);
        boolean isCharged = (Boolean)state.getValue((Property)ProjectRedBlock.CHARGED);
        MultiIconTransformation iconT = isWorking ? iconT3 : (isCharged ? iconT2 : iconT1);
        return new FullyOrientableBlockRenderer.RenderData(s, r, Objects.requireNonNull(iconT));
    }

    protected FullyOrientableBlockRenderer.RenderData getItemRenderData(ItemStack stack) {
        this.createIconTransforms();
        return new FullyOrientableBlockRenderer.RenderData(0, 0, Objects.requireNonNull(iconT1));
    }

    private void createIconTransforms() {
        if (iconT1 == null || FrameMotorBlockRenderer.iconT1.icons[0] != bottomIcon) {
            iconT1 = new MultiIconTransformation(new TextureAtlasSprite[]{bottomIcon, topIcon, frontBack0Icon, frontBack0Icon, leftIcon, rightIcon});
            iconT2 = new MultiIconTransformation(new TextureAtlasSprite[]{bottomIcon, topIcon, frontBack1Icon, frontBack1Icon, leftIcon, rightIcon});
            iconT3 = new MultiIconTransformation(new TextureAtlasSprite[]{bottomIcon, topIcon, frontBack2Icon, frontBack2Icon, leftIcon, rightIcon});
        }
    }

    public static void onTextureStitchEvent(TextureAtlasStitchedEvent event) {
        if (!event.getAtlas().location().equals((Object)TextureAtlas.LOCATION_BLOCKS)) {
            return;
        }
        topIcon = event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_expansion", (String)"block/frame_motor_top"));
        frontBack0Icon = event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_expansion", (String)"block/frame_motor_front_back_0"));
        frontBack1Icon = event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_expansion", (String)"block/frame_motor_front_back_1"));
        frontBack2Icon = event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_expansion", (String)"block/frame_motor_front_back_2"));
        leftIcon = event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_expansion", (String)"block/frame_motor_left"));
        rightIcon = event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_expansion", (String)"block/frame_motor_right"));
        bottomIcon = event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_expansion", (String)"block/frame_motor_bottom"));
    }

    public static TextureAtlasSprite getParticleIcon(BlockState state, int side) {
        return switch (side) {
            case 0 -> bottomIcon;
            case 1 -> topIcon;
            case 2, 3 -> frontBack0Icon;
            case 4 -> leftIcon;
            case 5 -> rightIcon;
            default -> throw new IllegalArgumentException("Invalid side: " + side);
        };
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean usesBlockLight() {
        return true;
    }

    @Nullable
    public PerspectiveModelState getModelState() {
        return TransformUtils.DEFAULT_BLOCK;
    }
}

