/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.inventory.container.CCLMenuType;
import codechicken.lib.vec.Vector3;
import javax.annotation.Nullable;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.core.inventory.BaseContainer;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.inventory.container.ChargingBenchMenu;
import mrtjp.projectred.expansion.item.IChargable;
import mrtjp.projectred.expansion.tile.LowLoadPoweredBlockEntity;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;

public class ChargingBenchBlockEntity
extends LowLoadPoweredBlockEntity {
    private final ChargingBenchInventory inventory = new ChargingBenchInventory();
    private final IItemHandler[] handlers = new IItemHandler[]{new SidedInvWrapper((WorldlyContainer)this.inventory, Direction.DOWN), new SidedInvWrapper((WorldlyContainer)this.inventory, Direction.UP)};
    private boolean isCharged = false;
    private int chargeSlot = 0;
    private int powerStored = 0;

    public ChargingBenchBlockEntity(BlockPos pos, BlockState state) {
        super(ExpansionBlocks.CHARGING_BENCH_BLOCK_ENTITY.get(), pos, state);
        this.inventory.addListener(c -> this.setChanged());
    }

    @Override
    public void saveToNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveToNBT(tag, lookupProvider);
        tag.putInt("storage", this.powerStored);
        tag.putByte("chargeSlot", (byte)this.chargeSlot);
        this.inventory.saveTo(tag, "inventory", lookupProvider);
    }

    @Override
    public void loadFromNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadFromNBT(tag, lookupProvider);
        this.powerStored = tag.getInt("storage");
        this.chargeSlot = tag.getByte("chargeSlot") & 0xFF;
        this.inventory.loadFrom(tag, "inventory", lookupProvider);
    }

    public void writeDesc(MCDataOutput out) {
        super.writeDesc(out);
    }

    public void readDesc(MCDataInput in) {
        super.readDesc(in);
    }

    public InteractionResult useWithoutItem(Player player, BlockHitResult hit) {
        if (!this.getLevel().isClientSide) {
            CCLMenuType.openMenu((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new ChargingBenchMenu(inv, this, id), (Component)this.getBlockState().getBlock().getName()), p -> p.writePos(this.getBlockPos()));
        }
        return InteractionResult.sidedSuccess((boolean)this.level.isClientSide);
    }

    public void onBlockRemoved() {
        super.onBlockRemoved();
        ChargingBenchBlockEntity.dropInventory((Container)this.inventory, (Level)this.getLevel(), (Vector3)Vector3.fromBlockPos((BlockPos)this.getBlockPos()));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getLevel().isClientSide) {
            return;
        }
        this.isCharged = this.canConductorWork();
        boolean changed = false;
        if (this.getConductorCharge() > this.getConductorUpperChargeTarget() && this.powerStored < this.getMaxStorage()) {
            int n = Math.min(this.getConductorCharge() - this.getConductorUpperChargeTarget(), this.getConductorChargeSpeed()) / 10;
            n = Math.min(n, this.getMaxStorage() - this.powerStored);
            this.conductor.applyPower((double)(n * -10));
            this.powerStored += n;
            if (n != 0) {
                changed = true;
            }
        }
        changed |= this.tryChargeItemInSlot(this.chargeSlot);
        changed |= this.tryDropDownItemInSlot(this.chargeSlot);
        this.chargeSlot = (this.chargeSlot + 1) % 8;
        BlockState state = this.getBlockState();
        if (this.isCharged != (Boolean)state.getValue((Property)ProjectRedBlock.CHARGED)) {
            this.pushBlockState();
        }
        if (changed) {
            this.setChanged();
        }
    }

    public int getMaxStorage() {
        return 8000;
    }

    public int getConductorUpperChargeTarget() {
        return 600;
    }

    protected int getConductorChargeSpeed() {
        return 100;
    }

    protected int getChargeSpeed() {
        return 15;
    }

    protected int getPowerStoredScaled(int i) {
        return Math.min(i, i * this.powerStored / this.getMaxStorage());
    }

    public BlockState storeBlockState(BlockState defaultState) {
        return (BlockState)super.storeBlockState(defaultState).setValue((Property)ProjectRedBlock.CHARGED, (Comparable)Boolean.valueOf(this.isCharged));
    }

    private boolean tryChargeItemInSlot(int i) {
        ItemStack stack = this.inventory.getItem(i);
        if (!stack.isEmpty() && stack.getItem() instanceof IChargable) {
            int toAdd = Math.min(this.powerStored, this.getChargeSpeed());
            Tuple<ItemStack, Integer> result = ((IChargable)stack.getItem()).addPower(stack, toAdd);
            this.inventory.setItem(i, (ItemStack)result.getA());
            this.powerStored -= ((Integer)result.getB()).intValue();
            return (Integer)result.getB() != 0;
        }
        return false;
    }

    private boolean tryDropDownItemInSlot(int i) {
        ItemStack stack = this.inventory.getItem(i);
        if (!stack.isEmpty() && stack.getItem() instanceof IChargable && ((IChargable)stack.getItem()).isFullyCharged(stack)) {
            InventoryLib.injectItemStack((Container)this.inventory, (ItemStack)stack, (int)8, (int)16, (boolean)false);
            this.inventory.setItem(i, stack.isEmpty() ? ItemStack.EMPTY : stack);
            return true;
        }
        return false;
    }

    public IItemHandler getHandler(Direction side) {
        return this.handlers[side == Direction.UP ? 1 : 0];
    }

    public Container getInventory() {
        return this.inventory;
    }

    public int getPowerStored() {
        return this.powerStored;
    }

    private static class ChargingBenchInventory
    extends BaseContainer
    implements WorldlyContainer {
        private static final int[] TOP_SLOTS = new int[8];
        private static final int[] BOTTOM_SLOTS = new int[8];

        public ChargingBenchInventory() {
            super(16);
        }

        public int getMaxStackSize() {
            return 1;
        }

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return stack.getItem() instanceof IChargable;
        }

        public int[] getSlotsForFace(Direction direction) {
            return direction == Direction.UP ? TOP_SLOTS : BOTTOM_SLOTS;
        }

        public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction direction) {
            return true;
        }

        public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction direction) {
            return true;
        }

        static {
            for (int i = 0; i < 8; ++i) {
                ChargingBenchInventory.TOP_SLOTS[i] = i;
                ChargingBenchInventory.BOTTOM_SLOTS[i] = i + 8;
            }
        }
    }
}

