/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import mrtjp.fengine.TileCoord;
import mrtjp.fengine.tiles.FETile;
import mrtjp.fengine.tiles.FETileMap;
import mrtjp.projectred.fabrication.editor.EditorDataUtils;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.engine.BaseTile;
import mrtjp.projectred.fabrication.engine.ICTileType;
import mrtjp.projectred.fabrication.engine.IIOConnectionTile;
import mrtjp.projectred.fabrication.engine.InterfaceSpec;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class BaseTileMap
implements FETileMap {
    private static final TileCoord defaultMinBounds = new TileCoord(-8, 0, -8);
    private static final TileCoord defaultMaxBounds = new TileCoord(7, 0, 7);
    private final Map<TileCoord, BaseTile> tileMap = new HashMap<TileCoord, BaseTile>();
    private final ICWorkbenchEditor editor;
    private final Set<IIOConnectionTile> ioTiles = new HashSet<IIOConnectionTile>();
    private final Map<Integer, Map<TileCoord, BaseTile>> layerToTileMap = new HashMap<Integer, Map<TileCoord, BaseTile>>();
    private TileCoord minBounds = defaultMinBounds;
    private TileCoord maxBounds = defaultMaxBounds;

    public BaseTileMap(ICWorkbenchEditor editor) {
        this.editor = editor;
    }

    public ICWorkbenchEditor getEditor() {
        return this.editor;
    }

    public TileCoord getMinBounds() {
        return this.minBounds;
    }

    public TileCoord getMaxBounds() {
        return this.maxBounds;
    }

    public TileCoord getDimensions() {
        return this.maxBounds.subtract(this.minBounds).add(1, 1, 1);
    }

    public void setBounds(TileCoord minBounds, TileCoord maxBounds) {
        this.minBounds = minBounds;
        this.maxBounds = maxBounds;
    }

    public boolean isInBounds(TileCoord coord) {
        return coord.x >= this.minBounds.x && coord.x <= this.maxBounds.x && coord.y >= this.minBounds.y && coord.y <= this.maxBounds.y && coord.z >= this.minBounds.z && coord.z <= this.maxBounds.z;
    }

    public boolean addTile(TileCoord coord, BaseTile tile) {
        if (!this.tileMap.containsKey(coord)) {
            this.tileMap.put(coord, tile);
            tile.bindMap(this, coord);
            this.cacheType(coord, tile);
            return true;
        }
        return false;
    }

    public Optional<BaseTile> removeTile(TileCoord coord) {
        BaseTile removed = this.tileMap.remove(coord);
        if (removed != null) {
            removed.unbindMap();
            this.uncacheType(coord, removed);
        }
        return Optional.ofNullable(removed);
    }

    public Optional<BaseTile> getBaseTile(TileCoord coord) {
        return Optional.ofNullable(this.tileMap.get(coord));
    }

    public int getTileCount() {
        return this.tileMap.size();
    }

    public Collection<Map.Entry<TileCoord, BaseTile>> getBaseTileEntries() {
        return this.tileMap.entrySet();
    }

    public Collection<Map.Entry<TileCoord, BaseTile>> getTilesOnLayer(int y) {
        return this.layerToTileMap.computeIfAbsent(y, k -> new HashMap()).entrySet();
    }

    public Collection<IIOConnectionTile> getIOTiles() {
        return this.ioTiles;
    }

    public void removeAll() {
        this.ioTiles.clear();
        for (BaseTile t : this.tileMap.values()) {
            t.unbindMap();
        }
        this.tileMap.clear();
        this.layerToTileMap.clear();
        this.minBounds = defaultMinBounds;
        this.maxBounds = defaultMaxBounds;
    }

    private void cacheType(TileCoord coord, BaseTile tile) {
        if (tile instanceof IIOConnectionTile) {
            this.ioTiles.add((IIOConnectionTile)((Object)tile));
        }
        this.layerToTileMap.computeIfAbsent(coord.y, k -> new HashMap()).put(coord, tile);
    }

    private void uncacheType(TileCoord coord, BaseTile tile) {
        if (tile instanceof IIOConnectionTile) {
            this.ioTiles.remove(tile);
        }
        this.layerToTileMap.get(coord.y).remove(coord);
    }

    public InterfaceSpec getInterfaceSpec() {
        return InterfaceSpec.fromIOTiles(this.ioTiles);
    }

    public void save(CompoundTag tag) {
        tag.putByte("format", (byte)1);
        ListTag tileList = new ListTag();
        for (Map.Entry<TileCoord, BaseTile> entry : this.tileMap.entrySet()) {
            CompoundTag tileTag = new CompoundTag();
            tileTag.putByte("_id", (byte)entry.getValue().getTileType().getID());
            tileTag.putByte("_x", (byte)entry.getKey().x);
            tileTag.putByte("_y", (byte)entry.getKey().y);
            tileTag.putByte("_z", (byte)entry.getKey().z);
            entry.getValue().save(tileTag);
            tileList.add((Object)tileTag);
        }
        tag.put("tiles", (Tag)tileList);
        EditorDataUtils.saveTileCoord(tag, "maxBounds", this.maxBounds);
        EditorDataUtils.saveTileCoord(tag, "minBounds", this.minBounds);
    }

    public void load(CompoundTag tag) {
        this.removeAll();
        int format = tag.getByte("format") & 0xFF;
        ListTag tileList = tag.getList("tiles", 10);
        for (int i = 0; i < tileList.size(); ++i) {
            CompoundTag tileTag = tileList.getCompound(i);
            int id = tileTag.getByte("_id") & 0xFF;
            byte x = tileTag.getByte("_x");
            byte y = tileTag.getByte("_y");
            byte z = tileTag.getByte("_z");
            BaseTile tile = Objects.requireNonNull(ICTileType.createFromIdAndFormat(id, format));
            this.addTile(new TileCoord((int)x, (int)y, (int)z), tile);
            tile.load(tileTag);
        }
        this.maxBounds = EditorDataUtils.loadTileCoord(tag, "maxBounds");
        this.minBounds = EditorDataUtils.loadTileCoord(tag, "minBounds");
    }

    public void writeDesc(MCDataOutput out) {
        out.writeByte(this.minBounds.x).writeByte(this.minBounds.y).writeByte(this.minBounds.z);
        out.writeByte(this.maxBounds.x).writeByte(this.maxBounds.y).writeByte(this.maxBounds.z);
        for (Map.Entry<TileCoord, BaseTile> entry : this.tileMap.entrySet()) {
            out.writeByte(entry.getValue().getTileType().getID());
            out.writeByte(entry.getKey().x);
            out.writeByte(entry.getKey().y);
            out.writeByte(entry.getKey().z);
            entry.getValue().writeDesc(out);
        }
        out.writeByte(255);
    }

    public void readDesc(MCDataInput in) {
        this.removeAll();
        this.minBounds = new TileCoord((int)in.readByte(), (int)in.readByte(), (int)in.readByte());
        this.maxBounds = new TileCoord((int)in.readByte(), (int)in.readByte(), (int)in.readByte());
        short id = in.readUByte();
        while (id != 255) {
            BaseTile tile = Objects.requireNonNull(ICTileType.createFromId(id));
            TileCoord coord = new TileCoord((int)in.readByte(), (int)in.readByte(), (int)in.readByte());
            this.addTile(coord, tile);
            tile.readDesc(in);
            id = in.readUByte();
        }
    }

    public Optional<FETile> getTile(TileCoord coord) {
        return Optional.ofNullable((FETile)this.tileMap.get(coord));
    }

    public Collection<FETileMap.TileMapEntry> getEntries() {
        return FastStream.of(this.tileMap.entrySet()).map(e -> new FETileMap.TileMapEntry(){
            final /* synthetic */ Map.Entry val$e;
            {
                this.val$e = entry;
            }

            public TileCoord getCoord() {
                return (TileCoord)this.val$e.getKey();
            }

            public FETile getTile() {
                return (FETile)this.val$e.getValue();
            }
        }).toImmutableList();
    }
}

