/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mrtjp.fengine.TileCoord;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.engine.log.ICCompilerLog;
import mrtjp.projectred.fabrication.gui.CTNListNode;
import mrtjp.projectred.fabrication.gui.ICRenderNode;
import mrtjp.projectred.fabrication.gui.ICRenderTypes;
import mrtjp.projectred.fabrication.gui.ICompileOverlayRenderer;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchCompileTab;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.lib.Rect;
import mrtjp.projectred.redui.AbstractGuiNode;
import mrtjp.projectred.redui.RedUINode;
import mrtjp.projectred.redui.ScrollBarNode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;

public class CompileStackTab
extends AbstractGuiNode
implements ICompileOverlayRenderer {
    private final ICWorkbenchEditor editor;
    private final CTNListNode ctnListNode = new CTNListNode();

    public CompileStackTab(ICWorkbenchEditor editor) {
        this.editor = editor;
        this.setSize(91, 134);
        this.initSubNodes();
    }

    private void initSubNodes() {
        this.ctnListNode.setPosition(6, 31);
        this.ctnListNode.setSize(79, 95);
        this.addChild((RedUINode)this.ctnListNode);
        ScrollBar scrollBar = new ScrollBar(this);
        scrollBar.setPosition(77, 31);
        scrollBar.setZPosition(0.2);
        scrollBar.setSize(8, 95);
        scrollBar.setSliderSize(8, 16);
        this.addChild((RedUINode)scrollBar);
    }

    public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
        graphics.blit(ICWorkbenchCompileTab.TAB_BACKGROUND, this.getFrame().x(), this.getFrame().y(), 0.0f, 223.0f, this.getFrame().width(), this.getFrame().height(), 512, 512);
    }

    public void onAddedToParent() {
        this.editor.getStateMachine().getCompilerLog().addTreeChangedListener(this::refreshList);
        this.refreshList();
    }

    private void refreshList() {
        List<ICCompilerLog.CompileTreeNode> execStack = this.editor.getStateMachine().getCompilerLog().getCurrentStack();
        this.ctnListNode.setNodeList(execStack);
    }

    private void renderCompileTreeNode(ICCompilerLog.CompileTreeNode node, CCRenderState ccrs, MultiBufferSource getter, PoseStack matrixStack) {
        ccrs.reset();
        ccrs.bind(ICRenderTypes.selectionRenderType, (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), matrixStack);
        ccrs.baseColour = EnumColour.LIGHT_BLUE.rgba(200);
        for (TileCoord pos : node.tileCoords) {
            Vector3 p = new Vector3((double)pos.x, (double)pos.y, (double)pos.z);
            ICRenderTypes.renderSelection(ccrs, p, p.copy().add(0.01), 0.1875, 0.125);
        }
    }

    @Override
    public void renderOverlay(ICRenderNode renderNode, Vector3 mousePosition, boolean isFirstHit, CCRenderState ccrs, MultiBufferSource getter, PoseStack matrixStack) {
        for (ICCompilerLog.CompileTreeNode node : this.editor.getStateMachine().getCompilerLog().getCurrentStack()) {
            this.renderCompileTreeNode(node, ccrs, getter, matrixStack);
        }
    }

    @Override
    public void buildTooltip(ICRenderNode renderNode, Vector3 mousePosition, List<Component> tooltip) {
    }

    private class ScrollBar
    extends ScrollBarNode {
        public ScrollBar(CompileStackTab compileStackTab) {
            super(ScrollBarNode.ScrollAxis.VERTICAL);
        }

        protected void drawSlider(GuiGraphics graphics, Rect sliderFrame) {
            graphics.blit(ICWorkbenchCompileTab.TAB_BACKGROUND, sliderFrame.x(), sliderFrame.y(), 305.0f, 58.0f, sliderFrame.width(), sliderFrame.height(), 512, 512);
        }

        protected void adjustContent(double scrollPercentage) {
        }
    }
}

