/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.util.MultipartPlaceContext;
import java.util.function.Function;
import javax.annotation.Nullable;
import mrtjp.fengine.api.ICFlatMap;
import mrtjp.projectred.core.BundledSignalsLib;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.engine.ICInterfaceType;
import mrtjp.projectred.fabrication.engine.ICSimulationContainer;
import mrtjp.projectred.fabrication.engine.InterfaceSpec;
import mrtjp.projectred.fabrication.engine.PRFabricationEngine;
import mrtjp.projectred.fabrication.init.FabricationDataComponents;
import mrtjp.projectred.fabrication.item.component.ICDataComponent;
import mrtjp.projectred.integration.GateType;
import mrtjp.projectred.integration.part.BundledGatePart;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class FabricatedGatePart
extends BundledGatePart {
    private final ICSimulationContainer simulationContainer = new ICSimulationContainer();
    private long simulationTimeStart = -1L;
    private ICDataComponent icDataComponent = ICDataComponent.EMPTY;

    public FabricatedGatePart() {
        super(GateType.FABRICATED_GATE);
    }

    public boolean preparePlacement(MultipartPlaceContext context) {
        if (!super.preparePlacement(context)) {
            return false;
        }
        if (context.getPlayer() == null || context.getPlayer().level().isClientSide()) {
            return false;
        }
        ItemStack stack = context.getItemInHand();
        ICDataComponent designData = (ICDataComponent)stack.get(FabricationDataComponents.IC_DATA_COMPONENT_TYPE);
        if (designData == null) {
            ProjectRedFabrication.LOGGER.warn("Gate placement issue: no NBT on gate item");
            return false;
        }
        if (!designData.canFabricate()) {
            ProjectRedFabrication.LOGGER.warn("Gate placement issue: gate item contains invalid data");
            return false;
        }
        this.icDataComponent = designData;
        ICFlatMap flatMap = PRFabricationEngine.instance.deserializeFlatMap(designData.getFlatMap());
        this.simulationContainer.setFlatMap(flatMap);
        return true;
    }

    public void save(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.save(tag, lookupProvider);
        tag.put("ic_data", (Tag)this.icDataComponent.save());
        tag.putLong("sim_time", this.level().getGameTime() - this.simulationTimeStart);
        this.simulationContainer.save(tag);
    }

    public void load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.load(tag, lookupProvider);
        this.icDataComponent = ICDataComponent.parse(tag.getCompound("ic_data")).orElse(ICDataComponent.EMPTY);
        this.simulationTimeStart = tag.getLong("sim_time");
        int compileFormat = this.icDataComponent.getCompileFormat();
        if (compileFormat == 1) {
            this.simulationContainer.load(tag);
        } else {
            ProjectRedFabrication.LOGGER.warn("Fabricated Gate compile format mismatch ({} vs {})", (Object)compileFormat, (Object)1);
        }
    }

    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeWithRegistryCodec(ICDataComponent.STREAM_CODEC, (Object)this.icDataComponent);
    }

    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.icDataComponent = (ICDataComponent)packet.readWithRegistryCodec(ICDataComponent.STREAM_CODEC);
    }

    public ItemStack getItem() {
        ItemStack stack = super.getItem();
        ICDataComponent.setComponent(stack, this.icDataComponent);
        return stack;
    }

    protected int outputMask(int shape) {
        InterfaceSpec ifSpec = this.icDataComponent.getInterfaceSpec();
        return ifSpec.getRedstoneOutputMask() | ifSpec.getAnalogOutputMask();
    }

    protected int inputMask(int shape) {
        InterfaceSpec ifSpec = this.icDataComponent.getInterfaceSpec();
        return ifSpec.getRedstoneInputMask() | ifSpec.getAnalogInputMask();
    }

    protected int getOutput(int r) {
        InterfaceSpec ifSpec = this.icDataComponent.getInterfaceSpec();
        if (!ifSpec.isOutput(r)) {
            return 0;
        }
        return switch (ifSpec.getInterfaceType(r)) {
            default -> throw new MatchException(null, null);
            case ICInterfaceType.NC, ICInterfaceType.BUNDLED -> 0;
            case ICInterfaceType.REDSTONE -> {
                if ((this.simulationContainer.getOutput(r) & 1) != 0) {
                    yield 15;
                }
                yield 0;
            }
            case ICInterfaceType.ANALOG -> BundledSignalsLib.mostSignificantBit((short)this.simulationContainer.getOutput(r));
        };
    }

    protected int bundledInputMask(int shape) {
        return this.icDataComponent.getInterfaceSpec().getBundledInputMask();
    }

    protected int bundledOutputMask(int shape) {
        return this.icDataComponent.getInterfaceSpec().getBundledOutputMask();
    }

    @Nullable
    protected byte[] getBundledOutput(int r) {
        InterfaceSpec ifSpec = this.icDataComponent.getInterfaceSpec();
        if (!ifSpec.isOutput(r)) {
            return null;
        }
        return switch (ifSpec.getInterfaceType(r)) {
            default -> throw new MatchException(null, null);
            case ICInterfaceType.NC, ICInterfaceType.REDSTONE, ICInterfaceType.ANALOG -> null;
            case ICInterfaceType.BUNDLED -> BundledSignalsLib.unpackDigital(null, (int)this.simulationContainer.getOutput(r));
        };
    }

    public int state2() {
        InterfaceSpec ifSpec = this.icDataComponent.getInterfaceSpec();
        int rsMask = ifSpec.getRedstoneInputMask() | ifSpec.getRedstoneOutputMask();
        int analogMask = ifSpec.getAnalogInputMask() | ifSpec.getAnalogOutputMask();
        int bundledMask = ifSpec.getBundledInputMask() | ifSpec.getBundledOutputMask();
        return rsMask & 0xF | (analogMask & 0xF) << 4 | (bundledMask & 0xF) << 8;
    }

    public String getGateName() {
        return this.icDataComponent.getName();
    }

    public boolean hasRuntimeError() {
        return this.icDataComponent.getCompileFormat() != 1;
    }

    protected void gateLogicOnWorldLoad() {
        this.simulationTimeStart = this.level().getGameTime() - this.simulationTimeStart;
    }

    protected void gateLogicSetup() {
        if (this.simulationTimeStart == -1L) {
            this.simulationTimeStart = this.level().getGameTime();
            this.tile().setChanged();
        }
    }

    protected void gateLogicOnChange() {
        short[] newInputs = new short[4];
        for (int r = 0; r < 4; ++r) {
            newInputs[r] = this.getModeBasedInput(r);
        }
        int changeMask = this.simulationContainer.setInputs(newInputs);
        if (changeMask != 0) {
            this.setState(this.state() & 0xF0 | this.getModeBasedInputStateMask());
            this.onInputChange();
            this.scheduleTick(2);
        }
    }

    protected void gateLogicOnScheduledTick() {
        this.simulationContainer.pushInputs(15);
        this.simulationContainer.simulate();
        int changeMask = this.simulationContainer.pullOutputs();
        if (changeMask != 0) {
            this.setState(this.state() & 0xF | this.getModeBasedOutputStateMask() << 4);
            this.onOutputChange(changeMask);
        }
        this.gateLogicOnChange();
    }

    protected void gateLogicOnTick() {
        if (!this.level().isClientSide) {
            long simTimeElapsed = this.level().getGameTime() - this.simulationTimeStart;
            this.simulationContainer.setSystemTime(simTimeElapsed);
            this.simulationContainer.pushTime();
            this.simulationContainer.simulate();
            int changeMask = this.simulationContainer.pullOutputs();
            if (changeMask != 0) {
                this.setState(this.state() & 0xF | this.getModeBasedOutputStateMask() << 4);
                this.onOutputChange(changeMask);
            }
        }
    }

    private short getModeBasedInput(int r) {
        InterfaceSpec ifSpec = this.icDataComponent.getInterfaceSpec();
        if (!ifSpec.isInput(r)) {
            return 0;
        }
        return switch (ifSpec.getInterfaceType(r)) {
            default -> throw new MatchException(null, null);
            case ICInterfaceType.NC -> 0;
            case ICInterfaceType.REDSTONE -> (short)(this.getRedstoneInput(r) != 0 ? 65535 : 0);
            case ICInterfaceType.BUNDLED -> (short)BundledSignalsLib.packDigital((byte[])this.getBundledInput(r));
            case ICInterfaceType.ANALOG -> (short)(1 << this.getAnalogRedstoneInput(r));
        };
    }

    private int getModeBasedInputStateMask() {
        return this.getSignalStateMask(this.simulationContainer::getInput);
    }

    private int getModeBasedOutputStateMask() {
        return this.getSignalStateMask(this.simulationContainer::getOutput);
    }

    private int getSignalStateMask(Function<Integer, Short> signalSupplier) {
        InterfaceSpec ifSpec = this.icDataComponent.getInterfaceSpec();
        int mask = 0;
        for (int r = 0; r < 4; ++r) {
            short input = signalSupplier.apply(r);
            mask |= (switch (ifSpec.getInterfaceType(r)) {
                default -> throw new MatchException(null, null);
                case ICInterfaceType.NC -> 0;
                case ICInterfaceType.BUNDLED, ICInterfaceType.REDSTONE -> {
                    if (input != 0) {
                        yield 1;
                    }
                    yield 0;
                }
                case ICInterfaceType.ANALOG -> BundledSignalsLib.mostSignificantBit((short)input) > 0 ? 1 : 0;
            }) << r;
        }
        return mask;
    }
}

