/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mrtjp.projectred.fabrication.editor.tools.EraseTool;
import mrtjp.projectred.fabrication.editor.tools.GatePlacerTool;
import mrtjp.projectred.fabrication.editor.tools.IICEditorTool;
import mrtjp.projectred.fabrication.editor.tools.InteractTool;
import mrtjp.projectred.fabrication.editor.tools.WirePlacerTool;

public enum ICEditorToolType {
    INTERACT_TOOL(InteractTool::new),
    ERASE_TOOL(EraseTool::new),
    GATE_PLACER_TOOL(GatePlacerTool::new),
    WIRE_PLACER_TOOL(WirePlacerTool::new);

    private final Supplier<IICEditorTool> factory;

    private ICEditorToolType(Supplier<IICEditorTool> factory) {
        this.factory = factory;
    }

    public IICEditorTool createTool() {
        return this.factory.get();
    }

    public static ArrayList<IICEditorTool> createToolList() {
        return Arrays.stream(ICEditorToolType.values()).map(ICEditorToolType::createTool).collect(Collectors.toCollection(ArrayList::new));
    }
}

