/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine;

import javax.annotation.Nullable;

public interface IConnectableICTile {
    public int getConnMask();

    public void setConnMask(int var1);

    @Nullable
    public IConnectableICTile getTileTowardsDir(int var1);

    default public int dirFrom(int dir) {
        return dir ^ 1;
    }

    default public boolean maskConnectsToDir(int dir) {
        return (this.getConnMask() & 1 << dir) != 0;
    }

    default public boolean updateConns() {
        int newConn = 0;
        for (int s = 0; s < 6; ++s) {
            if (!this.discoverAndConnect(s)) continue;
            newConn |= 1 << s;
        }
        if (newConn != this.getConnMask()) {
            this.setConnMask(newConn);
            this.onMaskChanged();
            return true;
        }
        return false;
    }

    default public boolean discoverAndConnect(int dir) {
        IConnectableICTile tileTowardsDir = this.getTileTowardsDir(dir);
        if (tileTowardsDir == null) {
            return false;
        }
        return this.canConnectTo(tileTowardsDir, dir) && tileTowardsDir.connect(this, this.dirFrom(dir));
    }

    default public boolean connect(IConnectableICTile target, int towardsDir) {
        if (this.canConnectTo(target, towardsDir)) {
            int newConn = this.getConnMask() | 1 << towardsDir;
            if (newConn != this.getConnMask()) {
                this.setConnMask(newConn);
                this.onMaskChanged();
            }
            return true;
        }
        return false;
    }

    public boolean canConnectTo(IConnectableICTile var1, int var2);

    public void onMaskChanged();
}

