/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import java.util.ArrayList;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICSimulation;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.engine.PRFabricationEngine;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.RedstoneTimerGateTile;

public class TimerGateTile
extends RedstoneTimerGateTile {
    public TimerGateTile() {
        super(ICGateTileType.TIMER);
    }

    @Override
    protected int redstoneInputMask() {
        return 4;
    }

    @Override
    protected int redstoneOutputMask() {
        return 11;
    }

    @Override
    public boolean isPointerStarted() {
        if (!this.getEditor().getStateMachine().isSimulating()) {
            return false;
        }
        long simTime = this.getEditor().getStateMachine().getSimSystemTime();
        return this.getState2() == 2 && simTime < this.pointerStartTime + (long)this.pointerMax;
    }

    @Override
    protected void collectGate(ICAssemblyTile.Collector collector, int gateId, int[] inputRegisters, int[] outputRegisters) {
        int i;
        ArrayList<Integer> inputRegs = new ArrayList<Integer>();
        ArrayList<Integer> outputRegs = new ArrayList<Integer>();
        inputRegs.add(this.stateReg);
        inputRegs.add(inputRegisters[2]);
        for (i = 0; i < 8; ++i) {
            inputRegs.add(this.timeRegs[i]);
        }
        for (i = 0; i < 8; ++i) {
            inputRegs.add(PRFabricationEngine.REG_TIME[i]);
        }
        outputRegs.add(this.stateReg);
        outputRegs.add(outputRegisters[0]);
        outputRegs.add(outputRegisters[1]);
        outputRegs.add(outputRegisters[3]);
        for (i = 0; i < 8; ++i) {
            outputRegs.add(this.timeRegs[i]);
        }
        collector.addGate(gateId, (ICGate)new TimerGate(this.pointerMax), inputRegs, outputRegs);
    }

    public static class TimerGate
    implements ICGate {
        private final long pointerMax;

        public TimerGate(long pointerMax) {
            this.pointerMax = pointerMax;
        }

        private static byte readState(ICSimulation ic, int[] inputs) {
            return ic.getRegByteVal(inputs[0]);
        }

        private static byte readInput(ICSimulation ic, int[] inputs) {
            return ic.getRegByteVal(inputs[1]);
        }

        private static long readStartTime(ICSimulation ic, int[] inputs) {
            return ic.getRegLongVal(inputs, 2);
        }

        private static long readSysTime(ICSimulation ic, int[] inputs) {
            return ic.getRegLongVal(inputs, 10);
        }

        private static void writeState(ICSimulation ic, int[] outputs, byte state) {
            ic.queueRegByteVal(outputs[0], state);
        }

        private static void writeOutput(ICSimulation ic, int[] outputs, byte output) {
            ic.queueRegByteVal(outputs[1], output);
            ic.queueRegByteVal(outputs[2], output);
            ic.queueRegByteVal(outputs[3], output);
        }

        private static void writeStartTime(ICSimulation ic, int[] outputs, long time) {
            ic.queueRegLongVal(outputs, 4, time);
        }

        private static void enterHaltState(ICSimulation ic, int[] outputs) {
            TimerGate.writeState(ic, outputs, (byte)1);
            TimerGate.writeOutput(ic, outputs, (byte)0);
            TimerGate.writeStartTime(ic, outputs, -1L);
        }

        private static void enterCountingState(ICSimulation ic, int[] inputs, int[] outputs) {
            TimerGate.writeState(ic, outputs, (byte)2);
            TimerGate.writeOutput(ic, outputs, (byte)0);
            TimerGate.writeStartTime(ic, outputs, TimerGate.readSysTime(ic, inputs));
        }

        private static void enterTickState(ICSimulation ic, int[] outputs) {
            TimerGate.writeState(ic, outputs, (byte)3);
            TimerGate.writeOutput(ic, outputs, (byte)1);
        }

        public void compute(ICSimulation ic, int[] inputs, int[] outputs) {
            byte stateVal = TimerGate.readState(ic, inputs);
            switch (stateVal) {
                case 0: {
                    TimerGate.enterHaltState(ic, outputs);
                    break;
                }
                case 1: {
                    if (TimerGate.readInput(ic, inputs) != 0) break;
                    TimerGate.enterCountingState(ic, inputs, outputs);
                    break;
                }
                case 2: {
                    if (TimerGate.readInput(ic, inputs) != 0) {
                        TimerGate.enterHaltState(ic, outputs);
                        break;
                    }
                    if (TimerGate.readSysTime(ic, inputs) < TimerGate.readStartTime(ic, inputs) + this.pointerMax) break;
                    TimerGate.enterTickState(ic, outputs);
                    break;
                }
                case 3: {
                    if (TimerGate.readSysTime(ic, inputs) < TimerGate.readStartTime(ic, inputs) + this.pointerMax + 2L) break;
                    if (TimerGate.readInput(ic, inputs) != 0) {
                        TimerGate.enterHaltState(ic, outputs);
                        break;
                    }
                    TimerGate.enterCountingState(ic, inputs, outputs);
                    break;
                }
                default: {
                    ProjectRedFabrication.LOGGER.error("Invalid state: " + stateVal);
                    TimerGate.enterHaltState(ic, outputs);
                }
            }
        }
    }
}

