/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.init;

import codechicken.multipart.api.MultipartClientRegistry;
import codechicken.multipart.api.part.render.PartRenderer;
import mrtjp.projectred.fabrication.client.RenderFabricatedGate;
import mrtjp.projectred.fabrication.gui.ICRenderTypes;
import mrtjp.projectred.fabrication.gui.screen.inventory.LithographyTableScreen;
import mrtjp.projectred.fabrication.gui.screen.inventory.PackagingTableScreen;
import mrtjp.projectred.fabrication.gui.screen.inventory.PlottingTableScreen;
import mrtjp.projectred.fabrication.init.FabricationMenus;
import mrtjp.projectred.fabrication.init.FabricationParts;
import mrtjp.projectred.integration.GateType;
import mrtjp.projectred.integration.client.GateModelRenderer;
import mrtjp.projectred.integration.client.GatePartRenderer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public class FabricationClientInit {
    public static void init(IEventBus modEventBus) {
        modEventBus.addListener(FabricationClientInit::clientSetup);
        modEventBus.addListener(ICRenderTypes::onTextureStitchEvent);
        modEventBus.addListener(FabricationClientInit::onRegisterMenuScreensEvent);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        MultipartClientRegistry.register(FabricationParts.FABRICATED_GATE_PART.get(), (PartRenderer)GatePartRenderer.INSTANCE);
        GateModelRenderer.registerRenderer((GateType)GateType.FABRICATED_GATE, RenderFabricatedGate::new);
    }

    private static void onRegisterMenuScreensEvent(RegisterMenuScreensEvent event) {
        event.register(FabricationMenus.PLOTTING_TABLE_MENU.get(), PlottingTableScreen::new);
        event.register(FabricationMenus.LITHOGRAPHY_TABLE_MENU.get(), LithographyTableScreen::new);
        event.register(FabricationMenus.PACKAGING_TABLE_MENU.get(), PackagingTableScreen::new);
    }
}

