/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.inventory.container;

import codechicken.lib.inventory.container.CCLMenuType;
import mrtjp.projectred.core.inventory.container.SimpleDataSlot;
import mrtjp.projectred.core.inventory.container.TakeOnlySlot;
import mrtjp.projectred.fabrication.init.FabricationMenus;
import mrtjp.projectred.fabrication.inventory.container.FabricationMachineMenu;
import mrtjp.projectred.fabrication.item.ValidDieItem;
import mrtjp.projectred.fabrication.tile.PackagingTableBlockEntity;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PackagingTableMenu
extends FabricationMachineMenu {
    public static CCLMenuType<PackagingTableMenu> FACTORY = (windowId, inventory, packet) -> {
        BlockEntity tile = inventory.player.level().getBlockEntity(packet.readPos());
        if (!(tile instanceof PackagingTableBlockEntity)) {
            return null;
        }
        return new PackagingTableMenu(inventory, (PackagingTableBlockEntity)tile, windowId);
    };
    private final Inventory playerInventory;
    private final PackagingTableBlockEntity tile;
    protected int problematicSlotMask;

    public PackagingTableMenu(Inventory playerInventory, PackagingTableBlockEntity tile, int windowId) {
        super(FabricationMenus.PACKAGING_TABLE_MENU.get(), windowId, tile);
        this.playerInventory = playerInventory;
        this.tile = tile;
        InventoryLib.addPlayerInventory((Inventory)playerInventory, (int)8, (int)89, arg_0 -> ((PackagingTableMenu)this).addSlot(arg_0));
        this.addPackagingTableInventory();
        this.addDataSlot((DataSlot)new SimpleDataSlot(tile::getProblematicSlotMask, value -> {
            this.problematicSlotMask = value;
        }));
    }

    private void addPackagingTableInventory() {
        InventoryLib.addInventory((Container)this.tile.getInventory(), (int)0, (int)46, (int)22, (int)3, (int)3, arg_0 -> ((PackagingTableMenu)this).addSlot(arg_0));
        this.addSlot((Slot)new TakeOnlySlot(this.tile.getInventory(), 9, 135, 40));
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack originalStack = stack.copy();
        if (this.isOutput(slotIndex) ? !this.moveToEntireInventory(stack, true) : (this.isHotbar(slotIndex) || this.isPlayerInventory(slotIndex) ? (this.isValidDie(stack) ? !this.moveToDieInput(stack, false) : (this.isPlayerInventory(slotIndex) ? !this.moveToHotbar(stack, false) : !this.moveToPlayerInventory(stack, false))) : this.isInputs(slotIndex) && !this.moveToEntireInventory(stack, false))) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stack.getCount() == originalStack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stack);
        return originalStack;
    }

    public int getProblematicSlotMask() {
        return this.problematicSlotMask;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isInputs(int slotIndex) {
        return slotIndex >= 36 && slotIndex < 45;
    }

    private boolean isOutput(int slotIndex) {
        return slotIndex == 45;
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 27, 36, reverse);
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 27, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 36, reverse);
    }

    private boolean moveToDieInput(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 40, 41, reverse);
    }

    private boolean isValidDie(ItemStack stack) {
        return stack.getItem() instanceof ValidDieItem;
    }
}

