/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.multipart.api.tile.RedstoneConnector;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.tile.BaseDeviceBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class FireStarterBlockEntity
extends BaseDeviceBlockEntity
implements RedstoneConnector {
    public FireStarterBlockEntity(BlockPos pos, BlockState state) {
        super(ExpansionBlocks.FIRE_STARTER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    protected void onActivated() {
        BlockPos pos = this.getBlockPos().relative(Direction.values()[this.side ^ 1]);
        this.emulateFlintAndSteel(pos);
    }

    private boolean emulateFlintAndSteel(BlockPos pos) {
        BlockState state = this.getLevel().getBlockState(pos);
        if (CampfireBlock.canLight((BlockState)state)) {
            FireStarterBlockEntity.playFlintAndSteelSound(this.getLevel(), pos);
            this.getLevel().setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 11);
            return true;
        }
        if (FireBlock.canBePlacedAt((Level)this.getLevel(), (BlockPos)pos, (Direction)Direction.NORTH)) {
            FireStarterBlockEntity.playFlintAndSteelSound(this.getLevel(), pos);
            this.getLevel().setBlock(pos, FireBlock.getState((BlockGetter)this.getLevel(), (BlockPos)pos), 11);
            return true;
        }
        return false;
    }

    private static void playFlintAndSteelSound(Level level, BlockPos pos) {
        level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
    }

    @Override
    protected void onDeactivated() {
        BlockPos pos = this.getBlockPos().relative(Direction.values()[this.side ^ 1]);
        BlockState state = this.getLevel().getBlockState(pos);
        if (CampfireBlock.isLitCampfire((BlockState)state)) {
            this.getLevel().setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)), 11);
            return;
        }
        if (state.is(Blocks.FIRE) || state.is(Blocks.SOUL_FIRE) || state.is(Blocks.NETHER_PORTAL)) {
            this.getLevel().setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        }
    }

    public boolean isFireSource(int side) {
        return this.active && this.side == (side ^ 1);
    }

    public int getConnectionMask(int side) {
        return (side ^ 1) == this.side ? 0 : 31;
    }

    public int weakPowerLevel(int side, int mask) {
        return 0;
    }
}

