/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.multipart.api.tile.RedstoneConnector;
import java.util.Objects;
import mrtjp.projectred.core.CenterLookup;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.part.PneumaticTubePayload;
import mrtjp.projectred.expansion.tile.BasePneumaticDeviceBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class TransposerBlockEntity
extends BasePneumaticDeviceBlockEntity
implements RedstoneConnector {
    public TransposerBlockEntity(BlockPos pos, BlockState state) {
        super(ExpansionBlocks.TRANSPOSER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    protected void onActivated() {
        if (this.importFromInventory()) {
            return;
        }
        this.suckEntities();
    }

    @Override
    protected void onDeactivated() {
    }

    protected int containerImportStackSize() {
        return 1;
    }

    private boolean importFromInventory() {
        Level level;
        IItemHandler itemCap;
        CenterLookup lookup = CenterLookup.lookupStraightCenter((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (int)(this.side ^ 1));
        if (lookup.tile == null) {
            return false;
        }
        BlockEntity blockEntity = lookup.tile;
        if (blockEntity instanceof WorldlyContainer) {
            int[] slots;
            WorldlyContainer wc = (WorldlyContainer)blockEntity;
            Direction extractDir = Direction.values()[lookup.otherDirection];
            for (int s : slots = wc.getSlotsForFace(extractDir)) {
                int toImport;
                ItemStack removed;
                ItemStack stack = wc.getItem(s);
                if (stack.isEmpty() || !wc.canTakeItemThroughFace(s, stack, extractDir) || (removed = wc.removeItem(s, toImport = Math.max(stack.getMaxStackSize(), this.containerImportStackSize()))).isEmpty()) continue;
                this.itemQueue.add(new PneumaticTubePayload(removed));
                return true;
            }
        }
        if ((itemCap = (IItemHandler)(level = Objects.requireNonNull(lookup.tile.getLevel())).getCapability(Capabilities.ItemHandler.BLOCK, lookup.tile.getBlockPos(), (Object)Direction.values()[lookup.otherDirection])) != null) {
            for (int s = 0; s < itemCap.getSlots(); ++s) {
                ItemStack extracted = itemCap.extractItem(s, this.containerImportStackSize(), false);
                if (extracted.isEmpty()) continue;
                this.itemQueue.add(new PneumaticTubePayload(extracted));
                return true;
            }
        }
        return false;
    }

    private boolean suckEntities() {
        return false;
    }

    @Override
    public int getConnectionMask(int side) {
        return (side ^ 1) == this.side ? 0 : 31;
    }

    @Override
    public int weakPowerLevel(int side, int mask) {
        return 0;
    }
}

