/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.engine.InterfaceSpec;
import mrtjp.projectred.fabrication.engine.PRFabricationEngine;
import mrtjp.projectred.fabrication.init.FabricationDataComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public class ICDataComponent
implements TooltipProvider {
    public static final ICDataComponent EMPTY = new ICDataComponent("EMPTY", 0, 0, 0, false, -1, InterfaceSpec.EMPTY, PRFabricationEngine.EMPTY_FLAT_MAP_SERIALIZED);
    private final String name;
    private final int tileCount;
    private final int warningCount;
    private final int errorCount;
    private final boolean isBuilt;
    private final int compileFormat;
    private final InterfaceSpec interfaceSpec;
    private final String flatMap;
    public static final Codec<ICDataComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(component -> component.name), (App)Codec.INT.fieldOf("tileCount").forGetter(component -> component.tileCount), (App)Codec.INT.fieldOf("warningCount").forGetter(component -> component.warningCount), (App)Codec.INT.fieldOf("errorCount").forGetter(component -> component.errorCount), (App)Codec.BOOL.fieldOf("isBuilt").forGetter(component -> component.isBuilt), (App)Codec.INT.fieldOf("compileFormat").forGetter(component -> component.compileFormat), (App)InterfaceSpec.CODEC.fieldOf("interfaceSpec").forGetter(component -> component.interfaceSpec), (App)Codec.STRING.fieldOf("flatMap").forGetter(component -> component.flatMap)).apply((Applicative)instance, ICDataComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ICDataComponent> STREAM_CODEC = StreamCodec.of((buf, component) -> {
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)component.name);
        ByteBufCodecs.INT.encode(buf, (Object)component.tileCount);
        ByteBufCodecs.INT.encode(buf, (Object)component.warningCount);
        ByteBufCodecs.INT.encode(buf, (Object)component.errorCount);
        ByteBufCodecs.BOOL.encode(buf, (Object)component.isBuilt);
        ByteBufCodecs.INT.encode(buf, (Object)component.compileFormat);
        InterfaceSpec.STREAM_CODEC.encode(buf, (Object)component.interfaceSpec);
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)component.flatMap);
    }, buf -> new ICDataComponent((String)ByteBufCodecs.STRING_UTF8.decode(buf), (Integer)ByteBufCodecs.INT.decode(buf), (Integer)ByteBufCodecs.INT.decode(buf), (Integer)ByteBufCodecs.INT.decode(buf), (Boolean)ByteBufCodecs.BOOL.decode(buf), (Integer)ByteBufCodecs.INT.decode(buf), (InterfaceSpec)InterfaceSpec.STREAM_CODEC.decode(buf), (String)ByteBufCodecs.STRING_UTF8.decode(buf)));

    public ICDataComponent(String name, int tileCount, int warningCount, int errorCount, boolean isBuilt, int compileFormat, InterfaceSpec interfaceSpec, String flatMap) {
        this.name = name;
        this.tileCount = tileCount;
        this.warningCount = warningCount;
        this.errorCount = errorCount;
        this.isBuilt = isBuilt;
        this.compileFormat = compileFormat;
        this.interfaceSpec = interfaceSpec;
        this.flatMap = flatMap;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ICDataComponent)) {
            return false;
        }
        ICDataComponent that = (ICDataComponent)o;
        return this.tileCount == that.tileCount && this.warningCount == that.warningCount && this.errorCount == that.errorCount && this.isBuilt == that.isBuilt && this.compileFormat == that.compileFormat && Objects.equals(this.name, that.name) && Objects.equals(this.interfaceSpec, that.interfaceSpec) && Objects.equals(this.flatMap, that.flatMap);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.tileCount, this.warningCount, this.errorCount, this.isBuilt, this.compileFormat, this.interfaceSpec, this.flatMap);
    }

    public String getName() {
        return this.name;
    }

    public int getTileCount() {
        return this.tileCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public boolean isBuilt() {
        return this.isBuilt;
    }

    public int getCompileFormat() {
        return this.compileFormat;
    }

    public InterfaceSpec getInterfaceSpec() {
        return this.interfaceSpec;
    }

    public String getFlatMap() {
        return this.flatMap;
    }

    @Nullable
    public static ICDataComponent getComponent(ItemStack stack) {
        return (ICDataComponent)stack.get(FabricationDataComponents.IC_DATA_COMPONENT_TYPE);
    }

    public static void setComponent(ItemStack stack, ICDataComponent component) {
        stack.set(FabricationDataComponents.IC_DATA_COMPONENT_TYPE, (Object)component);
    }

    public CompoundTag save() {
        DataResult result = CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this);
        if (result.isSuccess()) {
            Tag out = (Tag)result.getOrThrow();
            if (out instanceof CompoundTag) {
                return (CompoundTag)out;
            }
            ProjectRedFabrication.LOGGER.error("FabricationDesignDataComponent codec did not produce a CompoundTag: {}", (Object)out);
            return new CompoundTag();
        }
        ProjectRedFabrication.LOGGER.error("Failed to encode FabricationDesignDataComponent: {}", (Object)result.error());
        return new CompoundTag();
    }

    public static Optional<ICDataComponent> parse(CompoundTag tag) {
        DataResult result = CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag);
        if (result.isSuccess()) {
            return Optional.of((ICDataComponent)result.getOrThrow());
        }
        ProjectRedFabrication.LOGGER.error("Failed to parse FabricationDesignDataComponent: {}", (Object)result.error());
        return Optional.empty();
    }

    public boolean canFabricate() {
        return this.isBuilt && this.errorCount == 0 && this.isLatestCompileFormat();
    }

    public boolean isLatestCompileFormat() {
        return this.compileFormat == 1;
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipList, TooltipFlag flag) {
        tooltipList.accept((Component)Component.translatable((String)"projectred_fabrication.tooltip.name").append(": " + this.name).withStyle(ChatFormatting.GRAY));
        tooltipList.accept((Component)Component.translatable((String)"projectred_fabrication.tooltip.tile_count").append(": " + this.tileCount).withStyle(ChatFormatting.GRAY));
        tooltipList.accept((Component)Component.translatable((String)"projectred_fabrication.tooltip.io_types").append(": ").withStyle(ChatFormatting.GRAY));
        MutableComponent indent = Component.literal((String)"  ");
        tooltipList.accept((Component)indent.copy().append((Component)Component.translatable((String)"projectred_fabrication.tooltip.top")).append(": ").append((Component)Component.translatable((String)this.interfaceSpec.getInterfaceType(0).getUnlocalName())).withStyle(ChatFormatting.GRAY));
        tooltipList.accept((Component)indent.copy().append((Component)Component.translatable((String)"projectred_fabrication.tooltip.right")).append(": ").append((Component)Component.translatable((String)this.interfaceSpec.getInterfaceType(1).getUnlocalName())).withStyle(ChatFormatting.GRAY));
        tooltipList.accept((Component)indent.copy().append((Component)Component.translatable((String)"projectred_fabrication.tooltip.bottom")).append(": ").append((Component)Component.translatable((String)this.interfaceSpec.getInterfaceType(2).getUnlocalName())).withStyle(ChatFormatting.GRAY));
        tooltipList.accept((Component)indent.copy().append((Component)Component.translatable((String)"projectred_fabrication.tooltip.left")).append(": ").append((Component)Component.translatable((String)this.interfaceSpec.getInterfaceType(3).getUnlocalName())).withStyle(ChatFormatting.GRAY));
        tooltipList.accept((Component)Component.translatable((String)"projectred_fabrication.tooltip.input_mask").append(String.format(": 0x%X", this.interfaceSpec.getInputMask())).withStyle(ChatFormatting.GRAY));
        tooltipList.accept((Component)Component.translatable((String)"projectred_fabrication.tooltip.output_mask").append(String.format(": 0x%X", this.interfaceSpec.getOutputMask())).withStyle(ChatFormatting.GRAY));
        if (this.warningCount > 0) {
            tooltipList.accept((Component)Component.literal((String)"<!> ").withStyle(ChatFormatting.YELLOW).append((Component)Component.translatable((String)"projectred_fabrication.f.unit.warnings", (Object[])new Object[]{this.warningCount}).withStyle(ChatFormatting.GRAY)));
        }
        if (this.errorCount > 0) {
            tooltipList.accept((Component)Component.literal((String)"<!> ").withStyle(ChatFormatting.RED).append((Component)Component.translatable((String)"projectred_fabrication.f.unit.errors", (Object[])new Object[]{this.errorCount}).withStyle(ChatFormatting.GRAY)));
        }
        if (!this.isBuilt) {
            tooltipList.accept((Component)Component.literal((String)" - ").append((Component)Component.translatable((String)"projectred_fabrication.tooltip.fab_err.not_compiled")).withStyle(ChatFormatting.RED));
        }
        if ((!this.isBuilt || this.errorCount != 0) && this.isBuilt && this.errorCount > 0) {
            tooltipList.accept((Component)Component.literal((String)" - ").append((Component)Component.translatable((String)"projectred_fabrication.tooltip.fab_err.generic")).withStyle(ChatFormatting.RED));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private String name;
        private int tileCount = -1;
        private int warningCount = -1;
        private int errorCount = -1;
        private boolean isBuilt;
        private int compileFormat = -1;
        @Nullable
        private InterfaceSpec interfaceSpec;
        @Nullable
        private String flatMap;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setTileCount(int tileCount) {
            this.tileCount = tileCount;
            return this;
        }

        public Builder setWarningCount(int warningCount) {
            this.warningCount = warningCount;
            return this;
        }

        public Builder setErrorCount(int errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public Builder setBuilt(boolean isBuilt) {
            this.isBuilt = isBuilt;
            return this;
        }

        public Builder setCompileFormat(int compileFormat) {
            this.compileFormat = compileFormat;
            return this;
        }

        public Builder setInterfaceSpec(InterfaceSpec interfaceSpec) {
            this.interfaceSpec = interfaceSpec;
            return this;
        }

        public Builder setFlatMap(String flatMap) {
            this.flatMap = flatMap;
            return this;
        }

        public ICDataComponent build() {
            if (this.name == null || this.interfaceSpec == null || this.flatMap == null) {
                throw new IllegalArgumentException("Name, InterfaceSpec, and FlatMap cannot be null");
            }
            if (this.tileCount < 0 || this.warningCount < 0 || this.errorCount < 0 || this.compileFormat < 0) {
                throw new IllegalArgumentException("Tile count, warning count, error count, and compile format must be non-negative");
            }
            return new ICDataComponent(this.name, this.tileCount, this.warningCount, this.errorCount, this.isBuilt, this.compileFormat, this.interfaceSpec, this.flatMap);
        }
    }
}

