/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.devlogin.http.java11;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import net.covers1624.devlogin.http.HttpEngine;
import net.covers1624.devlogin.http.HttpResponse;
import org.jetbrains.annotations.Nullable;

public class JavaHttpEngine
extends HttpEngine {
    private final HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();

    @Override
    protected HttpResponse makeRequest(String method, String url, byte @Nullable [] body, Map<String, String> headers) throws IOException {
        java.net.http.HttpResponse<byte[]> resp;
        assert (!HttpEngine.requiresRequestBody(method) || body != null) : "HTTP Method" + method + " requires a body.";
        int i = 0;
        String[] interleavedHeaders = new String[headers.size() * 2];
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            interleavedHeaders[i++] = entry.getKey();
            interleavedHeaders[i++] = entry.getValue();
        }
        HttpRequest.BodyPublisher bodyPublisher = body != null ? HttpRequest.BodyPublishers.ofByteArray(body) : HttpRequest.BodyPublishers.noBody();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).headers(interleavedHeaders).method(method, bodyPublisher).build();
        try {
            resp = this.client.send(request, HttpResponse.BodyHandlers.ofByteArray());
        }
        catch (InterruptedException ex) {
            throw new IOException("Request failed. Interrupted.", ex);
        }
        return new HttpResponse(resp.statusCode(), null, resp.body());
    }

    @Override
    public void shutdown() throws IOException {
    }
}

