/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.devlogin.data;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.covers1624.devlogin.data.AuthenticationResponse;
import net.covers1624.devlogin.data.MinecraftAuthResponse;
import net.covers1624.devlogin.data.MinecraftProfile;

public class Account {
    public String username;
    public UUID uuid;
    public MSTokens msTokens;
    public MCTokens mcTokens;

    public Account() {
    }

    public Account(MinecraftProfile mcProfile, AuthenticationResponse msAuth, MinecraftAuthResponse mcAuth) {
        this.username = mcProfile.name;
        this.uuid = mcProfile.uuid();
        this.msTokens = new MSTokens(msAuth);
        this.mcTokens = new MCTokens(mcAuth);
    }

    public static class MCTokens {
        public String accessToken;
        public long expiresAt;

        public MCTokens() {
        }

        public MCTokens(MinecraftAuthResponse auth) {
            this.accessToken = auth.accessToken;
            this.expiresAt = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(auth.expiresIn);
        }
    }

    public static class MSTokens {
        public String accessToken;
        public String refreshToken;
        public long expiresAt;

        public MSTokens() {
        }

        public MSTokens(AuthenticationResponse auth) {
            this.accessToken = auth.accessToken;
            this.refreshToken = auth.refreshToken;
            this.expiresAt = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(auth.expiresIn);
        }
    }
}

