/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.devlogin.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.WillNotClose;

public class IOUtils {
    private static final ThreadLocal<byte[]> bufferCache = ThreadLocal.withInitial(() -> new byte[32768]);

    public static byte[] getCachedBuffer() {
        return bufferCache.get();
    }

    public static void copy(@WillNotClose InputStream is, @WillNotClose OutputStream os) throws IOException {
        int len;
        byte[] buffer = bufferCache.get();
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
    }

    public static byte[] toBytes(@WillNotClose InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.copy(is, os);
        return os.toByteArray();
    }

    public static Path makeParents(Path path) throws IOException {
        Path parent = (path = path.toAbsolutePath()).getParent();
        if (Files.notExists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        return path;
    }
}

