/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.devlogin.http;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.covers1624.devlogin.http.HttpResponse;
import org.jetbrains.annotations.Nullable;

public abstract class HttpEngine {
    private static final List<String> BUILTIN_ENGINES = Arrays.asList("net.covers1624.devlogin.http.java11.JavaHttpEngine", "net.covers1624.devlogin.http.apache.ApacheHttpEngine");
    private static final String MANUAL_ENGINE = System.getProperty("devlogin.http_engine");
    public static final String FORM_URL_ENCODED = "application/x-www-form-urlencoded";
    public static final String APPLICATION_JSON = "application/json";

    public final HttpResponse getJson(String url, Map<String, String> headers) throws IOException {
        headers = new HashMap<String, String>(headers);
        headers.put("Content-Type", APPLICATION_JSON);
        headers.put("Accept", APPLICATION_JSON);
        return this.makeRequest("GET", url, null, headers);
    }

    public final HttpResponse postJson(String url, Gson gson, Map<String, Object> body) throws IOException {
        return this.postJson(url, gson, body, new HashMap<String, String>());
    }

    public final HttpResponse postJson(String url, Gson gson, Map<String, Object> body, Map<String, String> headers) throws IOException {
        headers = new HashMap<String, String>(headers);
        headers.put("Content-Type", APPLICATION_JSON);
        headers.put("Accept", APPLICATION_JSON);
        return this.makeRequest("POST", url, gson.toJson(body).getBytes(StandardCharsets.UTF_8), headers);
    }

    public final HttpResponse postForm(String url, Map<String, String> body) throws IOException {
        return this.postForm(url, body, new HashMap<String, String>());
    }

    public final HttpResponse postForm(String url, Map<String, String> body, Map<String, String> headers) throws IOException {
        headers = new HashMap<String, String>(headers);
        headers.put("Content-Type", FORM_URL_ENCODED);
        return this.makeRequest("POST", url, HttpEngine.formEncode(body).getBytes(StandardCharsets.UTF_8), headers);
    }

    protected abstract HttpResponse makeRequest(String var1, String var2, byte @Nullable [] var3, Map<String, String> var4) throws IOException;

    public abstract void shutdown() throws IOException;

    public static String formEncode(Map<String, String> query) {
        try {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : query.entrySet()) {
                if (builder.length() > 0) {
                    builder.append("&");
                }
                builder.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                builder.append("=");
                builder.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Wot?", e);
        }
    }

    public static boolean requiresRequestBody(String method) {
        return method.equalsIgnoreCase("POST") || method.equalsIgnoreCase("PUT") || method.equalsIgnoreCase("PATCH") || method.equalsIgnoreCase("PROPPATCH") || method.equalsIgnoreCase("REPORT");
    }

    public static HttpEngine selectEngine() {
        if (MANUAL_ENGINE != null) {
            System.out.println("[DevLogin] Sysprop overriding HttpEngine to: " + MANUAL_ENGINE);
            HttpEngine engine = HttpEngine.tryLoad(MANUAL_ENGINE);
            if (engine == null) {
                System.exit(1);
            }
            return engine;
        }
        for (String builtinEngine : BUILTIN_ENGINES) {
            HttpEngine engine = HttpEngine.tryLoad(builtinEngine);
            if (engine == null) continue;
            return engine;
        }
        System.out.println("No HttpEngine could be loaded. Unable to continue.");
        System.exit(1);
        return null;
    }

    private static HttpEngine tryLoad(String cName) {
        System.out.println("[DevLogin] Trying to load HttpEngine: " + cName);
        try {
            Class<?> clazz = Class.forName(cName);
            return (HttpEngine)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            System.out.println("[DevLogin] failed to load HttpEngine: " + cName);
            return null;
        }
    }
}

