/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.devlogin.http.apache;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.covers1624.devlogin.http.HttpEngine;
import net.covers1624.devlogin.http.HttpResponse;
import net.covers1624.devlogin.util.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.Nullable;

public class ApacheHttpEngine
extends HttpEngine {
    private final CloseableHttpClient client = HttpClientBuilder.create().build();

    @Override
    protected HttpResponse makeRequest(String method, String url, byte @Nullable [] body, Map<String, String> headers) throws IOException {
        assert (!HttpEngine.requiresRequestBody(method) || body != null) : "HTTP Method" + method + " requires a body.";
        RequestBuilder builder = RequestBuilder.create((String)method);
        if (body != null) {
            builder.setEntity((HttpEntity)new ByteArrayEntity(body));
        }
        builder.setUri(url);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        try (CloseableHttpResponse resp = this.client.execute(builder.build());){
            int code = resp.getStatusLine().getStatusCode();
            String message = resp.getStatusLine().getReasonPhrase();
            HttpEntity entity = resp.getEntity();
            byte[] respBody = null;
            if (entity != null) {
                try (InputStream is = entity.getContent();){
                    respBody = IOUtils.toBytes(is);
                }
            }
            HttpResponse httpResponse = new HttpResponse(code, message, respBody);
            return httpResponse;
        }
    }

    @Override
    public void shutdown() throws IOException {
        this.client.close();
    }
}

